use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils;
use Test::Partner2::Mock;
use Test::Partner2::Simple;

use Test::Differences;
use Test::More;

use qbit;

run_tests(\&main_test, init => [qw(bk_statistics api_http_mol)],);

sub main_test {
    my ($app) = @_;
    mock_subs(
        {
            'Application::Model::API::Yandex::HTTPMOL::get_data' => sub {
                return {
                    'data' => [[2984581, '78800528324817'], [5706550, '22361560256608']],
                    'duration'        => '16.791',
                    'error_text'      => '',
                    'header'          => ['PartnerID', 'Price'],
                    'host-aggregator' => 'localhost',
                    'stat_time'       => 0,
                    'status'          => 0,
                    'total_rows'      => 2,
                    'totals'          => {'Price' => '101162088581425'}
                };
            },
        }
    );

    my $result = $app->bk_statistics->get_money_for_clients_on_dates(
        clients   => [2984581, 5706550],
        date_to   => '2021-08-30',
        date_from => '2021-08-01',
    );
    my $expected = get_test_data_and_update_if_needed('data.json', $result);
    eq_or_diff($result, $expected, 'check');
}
