use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Differences;

BEGIN {$ENV{DIFF_OUTPUT_UNICODE} = 1}

sub check_json_types {
    my ($app) = @_;

    my $tree = $app->bk_statistics->get_tree2();

    no strict 'refs';
    no warnings 'redefine';
    local *{'HTTP::Tiny::request'} = sub {
        return {
            content => '{
                "status"     : 0,
                "error_text" : "",
                "stat_time"  : 20170306204028,
                "header"     : ["UpdateTime","PageModel","PageID","DirectShows","MixedPartnerPrice"],
                "totals"     : {
                "MixedPartnerPrice" : "4102016",
                "DirectShows" : "634"
            },
                "total_rows" : 1,
                "host-aggregator" : "bsfastexport01i.yabs.yandex.ru",
                "duration"   : 0.068,
                "data"       : [["2017-03-01","context_on_site_campaign",148635,"634","4102016"]]
}',
            headers => {
                connection          => 'close',
                'content-type'      => 'text/plain; charset=utf-8',
                date                => 'Mon, 03 Oct 2016 15:24:24 GMT',
                server              => 'nginx/1.8.0',
                'transfer-encoding' => 'chunked',
                vary                => 'Accept-Encoding',
            },
            protocol => 'HTTP/1.1',
            reason   => 'OK',
            status   => 200,
            success  => 1,
        };
    };

    my $json = to_json(
        $app->bk_statistics->get_statistics2(
            'dimension_filter' => undef,
            'levels'           => [
                {
                    'filter' => ['AND', [['region_id', '=', ['113']], ['page_id', '=', '148635']]],
                    'id' => 'payment'
                }
            ],
            'entity_fields'    => ['page_level', 'page_id'],
            'vat'              => -1,
            'period'           => ['2017-03-01', '2017-03-01'],
            'dimension_fields' => ['date|day'],
            'order_by'         => [],
            'total'            => 0,
            'limits'           => {
                'limit'  => 50,
                'offset' => 0
            },
            'fields' => ['shows_direct', 'partner_wo_nds']
        ),
        pretty => 1,
    );

    eq_or_diff(
        $json,
        '{
   "currencies" : [
      {
         "code" : "USD",
         "id" : "1"
      },
      {
         "code" : "RUB",
         "id" : "2"
      },
      {
         "code" : "EUR",
         "id" : "3"
      }
   ],
   "dimensions" : {
      "date" : {
         "index" : 1,
         "title" : "mol_date",
         "type" : "date"
      },
      "page_id" : {
         "index" : 3,
         "title" : "mol_page_id",
         "type" : "page_id"
      },
      "page_level" : {
         "index" : 2,
         "title" : "mol_product_id",
         "type" : "categories"
      }
   },
   "is_last_page" : true,
   "measures" : {
      "partner_wo_nds" : {
         "index" : 4,
         "title" : "mol_rtb_partner_wo_nds",
         "type" : "money",
         "unit" : "money"
      },
      "shows_direct" : {
         "index" : 5,
         "title" : "mol_rtb_block_direct_shows",
         "type" : "number",
         "unit" : "count"
      }
   },
   "periods" : [
      [
         "2017-03-01",
         "2017-03-01"
      ]
   ],
   "points" : [
      {
         "dimensions" : {
            "date" : [
               "2017-03-01"
            ],
            "page_id" : 148635,
            "page_level" : "context_on_site_campaign"
         },
         "measures" : [
            {
               "partner_wo_nds" : 4.1,
               "shows_direct" : 634
            }
         ]
      }
   ],
   "report_title" : "Report for period 01.03.2017 - 01.03.2017",
   "total_rows" : 1,
   "totals" : {
      "2" : [
         {
            "partner_wo_nds" : 4.1,
            "shows_direct" : 634
         }
      ]
   }
}
',
    );

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        check_json_types($app);

    },
    user => 'yndx-bessarabov',
);
