use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use RoleRights;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        my @rights_in_model = keys(%{$app->bk_statistics->get_structure_rights_to_register()->[0]->{rights}});
        my @rights_from_file = grep {$_ =~ /^bk_statistics/} keys(%{RoleRights->new('production')->get_rights()});

        my $ok = cmp_bag(\@rights_in_model, \@rights_from_file, "rights in model and in role_rights.ssv are the same");

    },
);
