use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;
use Test::Deep;
use Test::Differences;
use qbit;

sub _by_somekey {
    if ('HASH' eq ref $a) {
        return exists $a->{index} ? $a->{index} cmp $b->{index} : $a->{id} cmp $b->{id};
    } elsif ('ARRAY' eq ref $a) {
        return $a->[0] cmp $b->[0];
    } else {
        return $a cmp $b;
    }
}

sub _sort_struct {
    my ($struct) = @_;

    if ('HASH' eq ref $struct) {
        foreach (keys %$struct) {
            $struct->{$_} = _sort_struct($struct->{$_});
        }
    } elsif ('ARRAY' eq ref $struct) {
        $struct = [sort _by_somekey @$struct];
        foreach (@$struct) {
            $_ = _sort_struct($_);
        }
    } else {
        return $struct;
    }
}

run_tests(
    sub {
        my ($app) = @_;

        my @logins = qw(
          yndx-developer
          mocked-yan-manager
          mocked-yan-partner-no-campaigns
          mocked-yan-partner
          mocked-yan-partner-assistant
          mocked-indoor-partner
          mocked-video-partner
          mocked-mobile-app-partner
          mocked-context-adblock-partner
          );

        my @result;
        foreach my $login (@logins) {
            change_cur_user($app, $login);
            my $result = $app->bk_statistics->get_tree2();
            push @result, [$login, $result];
        }
        my $has_data = get_test_data_and_update_if_needed('data.json', \@result);
        for (my $i = 0; $i < @$has_data; $i++) {
            my $expected_login = $has_data->[$i][0];
            my $expected_tree  = $has_data->[$i][1]{tree}[0];
            my $got_tree       = $result[$i][1]{tree}[0];
            foreach my $key (sort keys %$expected_tree) {
                my $got      = $got_tree->{$key};
                my $expected = $expected_tree->{$key};
                if ('ARRAY' eq ref $expected_tree->{$key}) {
                    _sort_struct($got);
                    _sort_struct($expected);
                }
                cmp_deeply($got, $expected, "$expected_login - $key - OK");
            }

        }
    },
    user => 'yndx-developer',
);
