use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

sub get_opts {
    my %opts = (
        dimension_fields => [],
        dimension_filter => undef,
        entity_fields    => [],
        fields           => ['shows',],
        levels           => [
            {
                filter => undef,
                id     => 'payment',
            },
        ],
        limits => {
            limit  => 50,
            offset => 0,
        },
        order_by => [
            {
                dir   => 'desc',
                field => 'shows',
            },
        ],
        period => 'today',
        total  => 0,
        vat    => -1,
    );

    return %opts;
}

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        local *{'HTTP::Tiny::request'} = sub {
            return {
                content => '{
                            "status"     : 0,
                            "error_text" : "",
                            "stat_time"  : 20161003180623,
                            "header"     : ["UpdateTime","DirectBannerShows","DirectBannerClicks"],
                            "totals"     : {
                            "DirectBannerClicks" : "1369190",
                            "DirectBannerShows" : "335213314"
                        },
                            "total_rows" : 1,
                            "host-aggregator" : "bsfastexport01h.yabs.yandex.ru",
                            "duration"   : 0.677,
                            "data"       : [["2016-10-03","335213314","1369190"]]
            }',
                headers => {
                    connection          => 'close',
                    'content-type'      => 'text/plain; charset=utf-8',
                    date                => 'Mon, 03 Oct 2016 15:24:24 GMT',
                    server              => 'nginx/1.8.0',
                    'transfer-encoding' => 'chunked',
                    vary                => 'Accept-Encoding',
                },
                protocol => 'HTTP/1.1',
                reason   => 'OK',
                status   => 200,
                success  => 1,
            };
        };

        change_cur_user($app, 'mocked-yan-partner');
        my $tmp_rights = $app->add_tmp_rights(qw(bk_statistics_view));

        eval {my $data = $app->statistics->get_statistics2(get_opts());};
        cmp_ok("$@", 'eq', '', 'working request');

        eval {my $data = $app->statistics->get_statistics2(get_opts(), fields => ['shows', 'all_wo_nds',],);};
        ok($@, 'select fields are hidden');
        is(ref($@), 'Exception::Validator::Errors', 'type is Exception::Validator::Errors');
        is(
            $@->message(), '[
   {
      "messages" : [
         "Incorrect value in fields"
      ],
      "name" : [
         "fields",
         "1"
      ]
   }
]
', 'message is expected'
        );

        eval {my $data = $app->statistics->get_statistics2(get_opts(), entity_fields => ['client_id',],);};
        ok($@, 'group by fields are hidden');
        is(ref($@), 'Exception::Validator::Errors', 'type is Exception::Validator::Errors');
        is(
            $@->message(), '[
   {
      "messages" : [
         "Incorrect value in entity_fields"
      ],
      "name" : [
         "entity_fields",
         "0"
      ]
   }
]
', 'message is expected'
        );

        eval {
            my $data = $app->statistics->get_statistics2(
                get_opts(),
                levels => [
                    {
                        filter => ['AND', [['client_id', '=', '1',],],],
                        id => 'payment',
                    },
                ],
            );
        };
        ok($@, 'where fields are hidden');
        is(ref($@),       'Exception::Validation::BadArguments', 'type is Exception::Validation::BadArguments');
        is($@->message(), 'Unknown fields "client_id"',          'message is expected');

    },
    create_clickhouse_db => 1,
);
