use qbit;
use Test::More;
require Application::Model::BkPiComparison;

sub check_no_diff {
    my $result = Application::Model::BkPiComparison::get_comparison_diff(
        undef,
        pi => [{123 => {domain => 'yandex.ru'}},],
        bk => [{123 => {domain => 'yandex.ru'}},],
    );
    is_deeply($result, undef, 'When there is no difference get_comparison_diff() returns undef');
}

sub check_incorrect_data {

    eval {
        my $result = Application::Model::BkPiComparison::get_comparison_diff(
            undef,
            pi => [{123 => {domain => 'yandex.ru'}},],
            bk => [{123 => {domain => 'ya.ru'}}, {124 => {domain => 'yandex.ru'}},],
        );
    };

    ok($@, 'get_comparison_diff() dies in case of incorrect data');
}

sub check_simple_case {
    my $result = Application::Model::BkPiComparison::get_comparison_diff(
        undef,
        pi => [{123 => {domain => 'yandex.ru'}},],
        bk => [{123 => {domain => 'ya.ru'}},],
    );
    is_deeply(
        $result,
        [{page_id => 123, pi => 'domain: yandex.ru', bk => 'domain: ya.ru'}],
        'get_comparison_diff() returns correct data'
    );
}

sub check_advanced_case {
    my $result = Application::Model::BkPiComparison::get_comparison_diff(
        undef,
        pi => [
            {123 => {domain => 'yandex.ru',         aa       => 1}},
            {124 => {domain => 'partner.yandex.ru', readonly => '1', mirrors => ''}},
        ],
        bk => [
            {123 => {domain => 'ya.ru',              aa       => 1}},
            {124 => {domain => 'partner2.yandex.ru', readonly => '', mirrors => ''}},
        ],
    );
    is_deeply(
        $result,
        [
            {page_id => 123, pi => 'domain: yandex.ru',         bk => 'domain: ya.ru'},
            {page_id => 124, pi => 'domain: partner.yandex.ru', bk => 'domain: partner2.yandex.ru'},
            {page_id => 124, pi => 'readonly: 1',               bk => 'readonly: '},
        ],
        'get_comparison_diff() returns correct data'
    );
}

sub check_no_data_in_bk {
    my $result = Application::Model::BkPiComparison::get_comparison_diff(
        undef,
        pi => [
            {123 => {domain => 'yandex.ru',         aa       => 1}},
            {124 => {domain => 'partner.yandex.ru', readonly => '1', mirrors => ''}},
        ],
        bk => [{123 => {domain => 'ya.ru', aa => 1}},],
    );

    is_deeply(
        $result,
        [
            {page_id => 123, pi => 'domain: yandex.ru',         bk => 'domain: ya.ru'},
            {page_id => 124, pi => 'domain: partner.yandex.ru', bk => 'domain: '},
            {page_id => 124, pi => 'readonly: 1',               bk => 'readonly: '},
        ],
        'get_comparison_diff() returns correct data'
    );
}

sub main {

    check_no_diff();
    check_incorrect_data();
    check_simple_case();
    check_advanced_case();
    check_no_data_in_bk();

    done_testing();

}
main();
