#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::More;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(mock_curdate get_bk_data get_new_video_an_site get_new_video_inpage);

use qbit;

use Utils::DomainBK qw(@DEFAULT_VIDEO_MIRRORS);
use Utils::PublicID qw(split_block_public_id);

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);
        mock_utils_partner2($app);

        my $page_id = $app->video_an_site->add(get_new_video_an_site({login => 'mocked-video-partner', platform => 0}));

        $app->video_an_site->do_action($page_id, 'start_testing');
        $app->video_an_site->do_action($page_id, 'start');

        my $public_id = $app->video_an_site_inpage->add(
            get_new_video_inpage(
                {
                    page_id          => $page_id,
                    geo              => '[{"id":"1","cpm":5}]',
                    alternative_code => undef,
                    blind            => 0
                }
            )
        );

        my (undef, undef, $block_id) = split_block_public_id($public_id);

        eq_or_diff(
            $app->video_an_site_inpage->_split_id($public_id),
            {page_id => $page_id, id => $block_id},
            'video_an_site_inpage->_split_id',
            {context => 5}
        );

        my $block_bk_data = {
            'Video' => {
                'Collapse'       => 0,
                'CountPositions' => '1',
                'Type'           => 'inpage',
                'CategoryID'     => '0',
                'Repeat'         => 0,
                'Stick'          => 0,
                'Protocols'      => [2, 3, 5, 6],
                'MaxDuration'    => '60',
                'API'            => [2],
                'StartTime'      => 0,
                'Preload'        => 1,
            },
            'BlindLevel'   => '0',
            'BlockModel'   => 'video_an_site_inpage',
            'BlockCaption' => 'Inpage',
            'MultiState'   => 18,
            'OptimizeType' => 0,
            'AdTypeSet'    => {
                'video-motion'      => 1,
                'video-performance' => 1,
                'video'             => 1,
                'media'             => 0,
                'text'              => 0,
                'media-performance' => 0
            },
            'DSPType'         => 2,
            'AlternativeCode' => undef,
            'Article'         => {},
            'PICategoryIAB'   => {},
            'page_id'         => $page_id,
            'AdType'          => {},
            'DSPInfo'         => [
                {
                    'DSPID' => '1',
                    'CPM'   => 1000,
                    'RF'    => {
                        'ShowsCount' => 12,
                        'Interval'   => 1800,
                    },
                }
            ],
            'Geo' => {
                '1' => {
                    'currency' => 'RUB',
                    'value'    => 5000
                },
                '213' => {
                    'currency' => 'RUB',
                    'value'    => 5000
                }
            },
            'Brand'      => {},
            'AdFoxBlock' => 0,
            'Sizes'      => [
                {
                    Width  => 0,
                    Height => 0,
                }
            ],
            'OrderTags'   => [],
            'TargetTags'  => [],
            'DSPSettings' => {
                'DSP'         => [1],
                'DSPBindMode' => 'force',
                'Unmoderated' => []
            },
            'MinCPM' => 1000
        };

        eq_or_diff(
            {$app->video_an_site_inpage->get_bk_data($page_id)},
            {rtb_blocks => {$block_id => $block_bk_data,}},
            "video_an_site_inpage->get_bk_data($page_id)",
            {context => 5}
        );

        # 34 - (Работает, Обновляется)
        $block_bk_data->{MultiState} = 34;
        eq_or_diff(
            get_bk_data($app->video_an_site, {page_id => $page_id}),
            {
                'banners_count'    => 9,
                'business_unit'    => '0',
                'client_id'        => '11010',
                'create_date'      => '2014-03-01 00:00:00',
                'description'      => 'test.video.com',
                'disabled_flags'   => ['bookmaker'],
                'domain'           => 'test.video.com',
                'excluded_domains' => [],
                'is_yandex_page'   => 0,
                'is_pi2'           => 1,
                'login'            => 'mocked-video-partner',
                'mirrors'          => \@DEFAULT_VIDEO_MIRRORS,
                'name'             => 'test.video.com',
                'page_caption'     => 'Video site caption',
                'page_id'          => $page_id,
                'page_options'     => {'Disable' => ['unmoderated-rtb-auction'], 'Enable' => []},
                'product_id'       => 'video_an_site',
                'product_type'     => 'video',
                'places'           => {},
                'rtb_blocks' => {'1' => $block_bk_data,},
                'rtb_video'  => {
                    'BufferEmptyLimit' => '5',
                    'SkipDelay'        => '10',
                    'Platform'         => 'flash',
                    'VASTTimeout'      => '5000',
                    'VideoTimeout'     => '5000',
                    'Title'            => 'Video site title',
                    'VPAIDEnabled'     => 1,
                    'VPAIDTimeout'     => '500',
                    'SkipTimeLeftShow' => '1',
                    'Contents'         => {},
                    'WrapperTimeout'   => '5000',
                    'Categories'       => {
                        '0' => {
                            'Archive' => '0',
                            'Name'    => "Основной видеоресурс"
                        },
                    },
                    'SkinTimeout'       => '5000',
                    'Skin'              => 'http://storage.mds.yandex.net/get-partner/14408/default.swf',
                    'BufferFullTimeout' => '5000',
                    'WrapperMaxCount'   => '3',
                    'TimeLeftShow'      => 1
                },
                'sad'         => 0,
                'state'       => 'work',
                'target_type' => 3,
                'OrderTags'   => [],
                'TargetTags'  => [],
                'update_time' => '2014-03-01 00:00:00',
            },
            "video_an_site->get_bk_data($page_id)",
            {context => 5}
        );
    },
    user   => 'mocked-video-manager',
    locale => 'en',
    init   => [qw(api_bk api_balance agreement_checker)],
);

sub mock_app {
    my ($app) = @_;

    mock_curdate('2014-03-01 00:00:00');

    my $PAGE_ID =
      $app->partner_db->video_an_site->get_all(fields => {'max_page_id' => {'MAX' => ['id']}})->[0]{'max_page_id'};

    $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});
    $app->api_bk->mock('create_or_update_campaign', sub {++$PAGE_ID});

    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
    $app->api_balance->mock('create_or_update_place', sub {1});

    $app->{'agreement_checker'} = Test::MockObject::Extends->new($app->{'agreement_checker'});
    $app->agreement_checker->mock('has_agreement_for_any_product_for_today', sub {1});
}
