use Test::Partner2::Simple;

use Test::Most;
use Test::More;
use Test::Deep qw(cmp_deeply ignore);
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils
  qw(set_test_partner_utils_app get_new_user restore_table add_bookmaker_filter get_hash_values get_new_video_an_site);
use Test::Partner2::Mock;

use qbit;

$Test::Partner2::Mock::PAGE_ID_START = 1;

sub insert {
    my ($self, $table, $fields, @row_hashes) = @_;
    @$fields = keys %{$row_hashes[0]} unless $fields;

    $self->do(
        "INSERT INTO $table (" . join(q{, }, @$fields) . ')
           VALUES  '
          . join(q{, }, ('(' . join(q{, }, ('?') x @$fields) . ')') x @row_hashes) . '
        ;',
        {},
        map {(get_hash_values($_, $fields)),} @row_hashes
    );
}

run_tests(
    sub {
        my ($app) = @_;

        set_test_partner_utils_app($app);
        mock_utils_partner2($app);

        $app->api_bk;
        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_http_gozora;
        $app->{'api_http_gozora'} = Test::MockObject::Extends->new($app->{'api_http_gozora'});

        $app->all_pages;
        $app->{'all_pages'} = Test::MockObject::Extends->new($app->{'all_pages'});

        $app->all_pages->mock(
            'get_all',
            sub {
                my ($self, %opts) = @_;
                my %owner_by_page = (1 => 11);
                return [{owner_id => $owner_by_page{$opts{'filter'}->{'page_id'}}}];
            }
        );

        mock_agreement_checker($app);

        my $PAGE_ID = 0;
        $app->api_bk->mock('create_or_update_campaign', sub {++$PAGE_ID});

        $app->api_balance->mock('create_or_update_place', sub {1});

        $app->api_http_gozora->mock('get_page_inf', sub {{body_length_bytes => 1}});

        mock_curdate('2014-03-01 00:00:00');

        my $dbh = $app->partner_db->get_dbh;

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        restore_table($dbh, $table_dumps_dir, 'tns_dict_article');
        restore_table($dbh, $table_dumps_dir, 'picategories_dict');
        restore_table($dbh, $table_dumps_dir, 'users');
        restore_table($dbh, $table_dumps_dir, 'dsp');

        insert($dbh, 'dsp_type', [qw(dsp_id type_id)], {dsp_id => 1,       type_id => 1,});
        insert($dbh, 'dsp_type', [qw(dsp_id type_id)], {dsp_id => 2,       type_id => 1,});
        insert($dbh, 'dsp_type', [qw(dsp_id type_id)], {dsp_id => 2563070, type_id => 1,});

        insert(
            $dbh,
            'geo_base',
            [qw(id parent_id name_ru name_en regularity level)],
            {
                id         => 1,
                parent_id  => undef,
                name_ru    => 'geo 1 ru',
                name_en    => 'geo 1 en',
                regularity => 0,
                level      => 0
            }
        );
        insert(
            $dbh,
            'geo_base',
            [qw(id parent_id name_ru name_en regularity level)],
            {
                id         => 2,
                parent_id  => 1,
                name_ru    => 'geo 2 ru',
                name_en    => 'geo 2 en',
                regularity => 0,
                level      => 0
            }
        );

        #Добавление  сайтов

        my @partner_rights = qw(
          do_video_an_site_instream_add
          do_video_an_site_instream_delete
          do_video_an_site_instream_edit
          do_video_an_site_instream_restore
          do_video_an_site_instream_start
          do_video_an_site_instream_stop
          video_an_site_edit
          video_an_site_instream_edit
          video_an_site_instream_edit_field__articles
          video_an_site_instream_edit_field__strategy
          video_an_site_instream_view_field__get_code
          );

        my @manager_rights = qw(
          do_video_an_site_add
          do_video_an_site_edit
          do_video_an_site_instream_add
          do_video_an_site_instream_delete
          do_video_an_site_instream_edit
          do_video_an_site_instream_restore
          do_video_an_site_instream_start
          do_video_an_site_instream_stop
          do_video_an_site_start
          do_video_an_site_start_testing
          users_view_all_video_an_partners
          users_view_field__is_tutby
          video_an_site_block_dsps_save
          video_an_site_edit
          video_an_site_add_other
          video_an_site_edit_field__partner_type
          video_an_site_instream_edit
          video_an_site_instream_edit_field__articles
          video_an_site_instream_edit_field__blind
          video_an_site_instream_edit_field__comment
          video_an_site_instream_edit_field__dsps
          video_an_site_instream_edit_field__dsp_list
          video_an_site_instream_edit_field__strategy
          video_an_site_instream_view_all
          video_an_site_instream_edit_field__strategy
          video_an_site_instream_view_field__blind
          video_an_site_instream_view_field__comment
          video_an_site_instream_view_field__dsps
          video_an_site_instream_view_field__get_code
          video_an_site_instream_view_field__is_tutby
          video_an_site_view_all
          video_an_site_view_field__owner
          video_an_site_view_field__partner_type
          view_search_filters__is_tutby
          view_search_filters__login
          );

        my $partner = get_new_user(
            users_add_opts => {client_id => 111},
            role_id        => 20,
            cur_user       => TRUE,
            adfox_id       => 12345,
        );
        $partner->{'rights'} = \@partner_rights;

        my $manager = get_new_user(
            users_add_opts => {client_id => 112},
            role_id        => 15,
            cur_user       => TRUE
        );
        $manager->{'rights'} = \@manager_rights;

        $app->set_option(cur_user => $partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @partner_rights};

        $app->set_option(cur_user => $manager);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @manager_rights};

        add_bookmaker_filter($app);

        $app->video_an_site->add(
            get_new_video_an_site(
                {
                    login    => 'good',
                    platform => 0,
                }
            )
        );

        $app->set_option(cur_user => $partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @partner_rights};

        eval {$app->video_an_site_instream->add()};
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
        is(ref($@) ? $@->message() : $@, gettext('Can not find site'), 'Exception message is correct.');

        $app->video_an_site_instream->add(
            page_id                   => 1,
            caption                   => 'Test block',
            category_id               => 0,
            category_path             => 'test.video.com',
            type                      => 0,
            max_duration              => 30,
            count_positions           => 1,
            geo                       => '[{"id":"1","cpm":5}]',
            strategy                  => 3,
            mincpm                    => undef,
            video_active              => 1,
            video_blocked             => 1,
            video_cpm                 => undef,
            video_performance_active  => 1,
            video_performance_blocked => 0,
            video_performance_cpm     => 30,
        );

        eval {
            $app->video_an_site_instream->add(
                page_id                   => 1,
                caption                   => 'Test block 2',
                category_id               => 0,
                category_path             => 'test.video.com',
                type                      => 0,
                max_duration              => 15,
                count_positions           => 2,
                mincpm                    => 57,
                strategy                  => 0,
                video_active              => undef,
                video_blocked             => undef,
                video_cpm                 => undef,
                video_performance_active  => undef,
                video_performance_blocked => undef,
                video_performance_cpm     => undef,
            );
        };
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
        is(
            ref($@) ? $@->message() : $@,
            gettext(
'For one category of the site, you can create 1 inpage, 1 pre, 1 post, 30 mid and 1 pause blocks. For this section of the site has already created the maximum number of blocks of this type.'
            ),
            'Exception message is correct.'
          );

        $app->video_an_site_instream->add(
            page_id                   => 1,
            caption                   => 'Test block 2',
            category_id               => 0,
            category_path             => 'test.video.com',
            type                      => 1,
            max_duration              => 15,
            count_positions           => 2,
            geo                       => '[{"id":"1","cpm":5},{"id":"2","cpm":20}]',
            mincpm                    => 57,
            strategy                  => 0,
            video_active              => undef,
            video_blocked             => undef,
            video_cpm                 => undef,
            video_performance_active  => undef,
            video_performance_blocked => undef,
            video_performance_cpm     => undef,
        );

        $app->video_an_site_instream->do_action('R-V-1-1', 'delete');
        is(
            $app->video_an_site_instream->check_multistate_flag(
                $app->video_an_site_instream->get('R-V-1-1', fields => ['multistate'])->{'multistate'}, 'deleted'
            ),
            TRUE,
            'Video site block - delete'
          );

        $app->video_an_site_instream->add(
            page_id                   => 1,
            caption                   => 'Test block 3',
            category_id               => 0,
            category_path             => 'test.video.com',
            type                      => 0,
            max_duration              => 30,
            count_positions           => 1,
            strategy                  => 3,
            mincpm                    => undef,
            video_active              => 1,
            video_blocked             => 1,
            video_cpm                 => undef,
            video_performance_active  => 1,
            video_performance_blocked => 0,
            video_performance_cpm     => 30,
        );

        eval {$app->video_an_site_instream->do_action('R-V-1-1', 'restore')};
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
        is(
            ref($@) ? $@->message() : $@,
            gettext(
'For one category of the site, you can create 1 inpage, 1 pre, 1 post, 30 mid and 1 pause blocks. For this section of the site has already created the maximum number of blocks of this type.'
            ),
            'Exception message is correct.'
          );

        $app->video_an_site_instream->do_action('R-V-1-3', 'delete');
        $app->video_an_site_instream->do_action('R-V-1-1', 'restore');

        $app->set_option(cur_user => $manager);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @manager_rights};

        $app->video_an_site->do_action('1', 'start_testing');
        $app->video_an_site->do_action('1', 'start');

        $app->set_option(cur_user => $partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @partner_rights};

        eval {$app->video_an_site_instream->do_action('R-V-1-1', 'edit', comment => 'Test comment', blind => TRUE);};
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
        is(
            ref($@) ? $@->message() : $@,
            gettext('You can not edit the following fields: %s', join(', ', sort qw(blind comment))),
            'Exception message is correct.'
          );

        $app->video_an_site_instream->do_action(
            'R-V-1-1', 'edit',
            caption                   => 'Test caption',
            mincpm                    => 40,
            articles                  => '[{"cpm":10,"id":"40"}]',
            brands                    => [],
            max_duration              => 180,
            count_positions           => 5,
            alternative_code          => '<html><head></head><body>Hello, world!</body></html>',
            geo                       => '[{"id":"1","cpm":5},{"id":"2","cpm":10}]',
            strategy                  => 0,
            video_active              => undef,
            video_blocked             => undef,
            video_cpm                 => undef,
            video_performance_active  => undef,
            video_performance_blocked => undef,
            video_performance_cpm     => undef,
        );

        eval {
            $app->video_an_site_instream->do_action(
                'R-V-1-1',
                'edit',
                dsps => [
                    {dsp_id => 1, show_count => undef, interval => undef},
                    {dsp_id => 2, show_count => 7,     interval => 1800}
                ]
            );
        };
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');

        $app->set_option(cur_user => $manager);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @manager_rights};

        $app->video_an_site_instream->do_action('R-V-1-1', 'edit',
            dsps =>
              [{dsp_id => 1, show_count => undef, interval => undef}, {dsp_id => 2, show_count => 7, interval => 1800}]
        );
        cmp_deeply(
            $app->video_an_site_instream->get('R-V-1-1', fields => ['dsps'])->{'dsps'},
            [{dsp_id => 1, show_count => undef, interval => undef}, {dsp_id => 2, show_count => 7, interval => 1800}],
            'Video site block - save dsps'
        );

        $app->video_an_site_instream->do_action(
            'R-V-1-1', 'edit',
            comment => 'Test comment',
            blind   => TRUE
        );

        $app->set_option(cur_user => $partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @partner_rights};

        cmp_deeply(
            {$app->video_an_site_instream->get_bk_data(1)},
            {
                'rtb_blocks' => {
                    '1' => {
                        'Video' => {
                            'CountPositions' => 5,
                            'Type'           => 'preroll',
                            'CategoryID'     => 0,
                            'StartTime'      => 0,
                            'Protocols'      => [2, 3, 5, 6],
                            'MaxDuration'    => 180,
                            'API'            => [2]
                        },
                        'page_id'      => 1,
                        'BlindLevel'   => 1,
                        'BlockCaption' => 'Test caption',
                        'MultiState'   => '18',
                        'OptimizeType' => 0,
                        'AdTypeSet'    => {
                            'video-motion'        => 1,
                            'video-performance'   => 1,
                            'video-non-skippable' => 1,
                            'video'               => 1,
                            'media'               => 0,
                            'text'                => 0,
                            'media-performance'   => 0
                        },
                        'AdType'          => {},
                        'DSPType'         => 2,
                        'AlternativeCode' => '<html><head></head><body>Hello, world!</body></html>',
                        'Article'         => {
                            '-41' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '2605' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '3862' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '40' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '93' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '94' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            },
                            '95' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            }
                        },
                        'PICategoryIAB' => {
                            '1' => {'VideoCreativeReach' => 10000},
                            '2' => {'VideoCreativeReach' => 10000},
                            '3' => {'VideoCreativeReach' => 10000}
                        },
                        'DSPInfo' => [
                            {
                                'DSPID' => 1,
                                'CPM'   => 40000,
                                'RF'    => {
                                    'ShowsCount' => 0,
                                    'Interval'   => 0,
                                },
                            },
                            {
                                'DSPID' => 2,
                                'CPM'   => 40000,
                                'RF'    => {
                                    'ShowsCount' => 7,
                                    'Interval'   => 1800,
                                },
                            }
                        ],
                        'Geo' => {
                            '1' => {
                                'currency' => 'RUB',
                                'value'    => 5000
                            },
                            '2' => {
                                'currency' => 'RUB',
                                'value'    => 10000
                            }
                        },
                        'BlockModel' => 'video_an_site_instream',
                        'Brand'      => {},
                        'AdFoxBlock' => 0,
                        'Sizes'      => [
                            {
                                Width  => 0,
                                Height => 0,
                            }
                        ],
                        'PageImpOptions' => {
                            'Enable'  => ['allow-multiple-dsp-ads'],
                            'Disable' => [],
                        },
                        'OrderTags'   => [],
                        'TargetTags'  => [],
                        'DSPSettings' => {
                            'DSP'         => [1, 2],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM' => 40000
                    },
                    '2' => {
                        AdFoxBlock     => 0,
                        'OptimizeType' => 0,
                        AdType         => {},
                        AdTypeSet      => {
                            media                 => 0,
                            'media-performance'   => 0,
                            text                  => 0,
                            video                 => 1,
                            'video-motion'        => 1,
                            'video-performance'   => 1,
                            'video-non-skippable' => 1,
                        },
                        AlternativeCode => undef,
                        Article         => {},
                        PICategoryIAB   => {},
                        BlindLevel      => 0,
                        'BlockModel'    => 'video_an_site_instream',
                        Brand           => {},
                        BlockCaption    => 'Test block 2',
                        MultiState      => 18,                         # 2  - working, 16 - need_update
                        DSPInfo         => [
                            {
                                'DSPID' => 1,
                                'CPM'   => 57000,
                                'RF'    => {
                                    'ShowsCount' => 0,
                                    'Interval'   => 0,
                                },
                            },
                            {
                                CPM   => 57000,
                                DSPID => 2563070,
                                'RF'  => {
                                    'ShowsCount' => 0,
                                    'Interval'   => 0,
                                },
                            },
                        ],
                        DSPType => 2,
                        Geo     => {
                            1 => {
                                currency => "RUB",
                                value    => 5000,
                            },
                            2 => {
                                currency => "RUB",
                                value    => 20000,
                            },
                        },
                        page_id => 1,
                        Video   => {
                            API            => [2,],
                            CategoryID     => 0,
                            CountPositions => 2,
                            MaxDuration    => 15,
                            Protocols      => [2, 3, 5, 6],
                            StartTime      => 0,
                            Type           => "postroll",
                        },
                        'Sizes' => [
                            {
                                Width  => 0,
                                Height => 0,
                            }
                        ],
                        'PageImpOptions' => {
                            'Enable'  => ['allow-multiple-dsp-ads'],
                            'Disable' => [],
                        },
                        'OrderTags'   => [],
                        'TargetTags'  => [],
                        'DSPSettings' => {
                            'DSP'         => [1, 2563070],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM' => 57000
                    },
                }
            },
            'video_an_site_instream - get_bk_data with platform "Flash"'
        );

        $app->set_option(cur_user => $manager);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @manager_rights};

        my $page_id = $app->video_an_site->add(
            domain              => 'test2.com',
            caption             => 'Test caption 2',
            login               => 'good',
            platform            => 2,
            title               => 'Test title 2',
            skip_delay          => 10,
            skip_time_left_show => TRUE,
            time_left_show      => TRUE,
            vpaid_enabled       => TRUE,
            vpaid_timeout       => 300,
        );

        $app->video_an_site->do_action($page_id, 'start_testing');
        $app->video_an_site->do_action($page_id, 'start');

        my $block_id = $app->video_an_site_instream->add(
            page_id                   => $page_id,
            caption                   => 'Test block 4',
            category_id               => 0,
            category_path             => 'test2.com',
            type                      => 0,
            max_duration              => 30,
            count_positions           => 1,
            dsps                      => [{dsp_id => '2563070'}],
            mincpm                    => 20,
            strategy                  => 0,
            video_active              => undef,
            video_blocked             => undef,
            video_cpm                 => undef,
            video_performance_active  => undef,
            video_performance_blocked => undef,
            video_performance_cpm     => undef,
        );

        cmp_deeply(
            {$app->video_an_site_instream->get_bk_data($page_id)},
            {
                'rtb_blocks' => {
                    '1' => {
                        'Video' => {
                            'CountPositions' => 1,
                            'Type'           => 'preroll',
                            'CategoryID'     => 0,
                            'StartTime'      => 0,
                            'Protocols'      => [2, 3, 5, 6],
                            'MaxDuration'    => 30,
                            'API'            => [3]
                        },
                        'page_id'      => $page_id,
                        'BlindLevel'   => 0,
                        'BlockCaption' => 'Test block 4',
                        'MultiState'   => '18',             # 2  - working, 16 - need_update
                        'OptimizeType' => 0,
                        'AdTypeSet'    => {
                            'video-motion'        => 1,
                            'video-performance'   => 1,
                            'video-non-skippable' => 1,
                            'video'               => 1,
                            'media'               => 0,
                            'text'                => 0,
                            'media-performance'   => 0
                        },
                        'DSPType'         => 2,
                        'AlternativeCode' => undef,
                        'Article'         => {},
                        'PICategoryIAB'   => {},
                        'AdType'          => {},
                        'DSPInfo'         => [
                            {
                                'DSPID' => 2563070,
                                'RF'    => {
                                    'Interval'   => 0,
                                    'ShowsCount' => 0
                                },
                                'CPM' => 20000
                            }
                        ],
                        'Geo'        => {},
                        'BlockModel' => 'video_an_site_instream',
                        'Brand'      => {},
                        'AdFoxBlock' => 0,
                        'Sizes'      => [
                            {
                                Width  => 0,
                                Height => 0,
                            }
                        ],
                        'PageImpOptions' => {
                            'Enable'  => ['allow-multiple-dsp-ads'],
                            'Disable' => [],
                        },
                        'OrderTags'   => [],
                        'TargetTags'  => [],
                        'DSPSettings' => {
                            'DSP'         => [2563070],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM' => 20000
                    },
                }
            },
            'video_an_site_instream - get_bk_data with platform "Mobile apps"'
        );

        $page_id = $app->video_an_site->add(
            domain              => 'test3.com',
            caption             => 'Test caption 3',
            login               => 'good',
            platform            => 2,
            title               => 'Test title 3',
            skip_delay          => 10,
            skip_time_left_show => TRUE,
            time_left_show      => TRUE,
            vpaid_enabled       => 0,
            vpaid_timeout       => 300,
        );
        $app->video_an_site->do_action($page_id, 'start_testing');
        $app->video_an_site->do_action($page_id, 'start');

        my $tmp_rights = $app->add_tmp_rights('video_an_site_add_adfox_block');

        $app->video_an_site_instream->add(
            page_id                   => $page_id,
            adfox_block               => 1,
            caption                   => 'Adfox Test block',
            category_id               => 0,
            category_path             => 'adfoxtest.com',
            type                      => 2,
            max_duration              => 30,
            count_positions           => 1,
            dsps                      => [{dsp_id => '2563070'}],
            mincpm                    => 20,
            strategy                  => 0,
            start_time                => 10,
            video_active              => undef,
            video_blocked             => undef,
            video_cpm                 => undef,
            video_performance_active  => undef,
            video_performance_blocked => undef,
            video_performance_cpm     => undef,
        );
        undef($tmp_rights);

        cmp_deeply(
            {$app->video_an_site_instream->get_bk_data($page_id)},
            {
                'rtb_blocks' => {
                    '1' => {
                        'AdFoxBlock' => 1,
                        'AdType'     => {},
                        'AdTypeSet'  => {
                            'media'               => 0,
                            'media-performance'   => 0,
                            'text'                => 0,
                            'video'               => 1,
                            'video-motion'        => 0,
                            'video-non-skippable' => 1,
                            'video-performance'   => 0,
                        },
                        'AlternativeCode' => undef,
                        'Article'         => {},
                        'PICategoryIAB'   => {},
                        'BlindLevel'      => 0,
                        'BlockCaption'    => 'Adfox Test block',
                        'BlockModel'      => 'video_an_site_instream',
                        'Brand'           => {},
                        'DSPInfo'         => [
                            {
                                'CPM'   => 20000,
                                'DSPID' => 2563070,
                                'RF'    => {
                                    'Interval'   => 0,
                                    'ShowsCount' => 0,
                                },
                            },
                        ],
                        'DSPType'        => 2,
                        'Geo'            => {},
                        'MultiState'     => 18,
                        'OptimizeType'   => 0,
                        'page_id'        => 3,
                        'PageImpOptions' => {
                            'Disable' => ['allow-multiple-dsp-ads',],
                            'Enable'  => [],
                        },
                        'Sizes' => [
                            {
                                'Height' => 0,
                                'Width'  => 0,
                            },
                        ],
                        'Video' => {
                            'API'               => [],
                            'CategoryID'        => 0,
                            'CountPositions'    => 1,
                            'MaxDuration'       => 30,
                            'Protocols'         => [2, 3, 5, 6],
                            'StartTime'         => 10,
                            'Type'              => 'midroll',
                            'MetadataAdEnabled' => 0,
                            'BroadcastReplace'  => 1,
                            'Pip'               => 0,
                        },
                        'OrderTags'   => [],
                        'TargetTags'  => [],
                        'DSPSettings' => {
                            'DSP'         => [2563070],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM' => 20000
                    },
                },
            },
            'video_an_site_instream - get_bk_data with platform "Mobile apps" and adfox_block and vpaid_enabled = 0'
        );
    },
    fill_databases => 0,
    locale         => "en"
);
