#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply ignore);
use Test::Most qw();

use Test::MockObject::Extends::Easy;
use Test::Partner2::Mock qw(mock_bk mock_agreement_checker mock_utils_partner2);
use Test::Partner::Utils;

no warnings 'redefine';

# global vars
$Test::Partner2::Mock::PAGE_ID_START = 12345;
my $MOCKED_PAGE_ID = $Test::Partner2::Mock::PAGE_ID_START;

# subs

sub mock_balance {
    my ($app) = @_;

    $app->{api_balance} = Test::MockObject::Extends::Easy->new($app->{api_balance});

    $app->api_balance->mock(
        'create_or_update_place',
        sub {
            my ($self, %opts) = @_;

            return [];
        }
    );
}

sub create_video_an_site {
    my ($app) = @_;

    note('creating video');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "test.video.com",
                    Domain       => "test.video.com",
                    IsYandexPage => 0,
                    Name         => "test.video.com",
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    State        => -1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'Video site caption',
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site->add(
        get_new_video_an_site(
            {
                login         => 'mocked-video-partner',
                vpaid_enabled => 0,
            }
        )
    );

    note('do_action start:');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "example.com",
                    Domain       => "example.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "example.com",
                    PageID       => $MOCKED_PAGE_ID,
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    ProductType  => 'video',
                    RtbVideo     => {
                        Platform          => 'html5',
                        BufferEmptyLimit  => 5,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 5000,
                        SkipDelay        => 0,
                        SkipTimeLeftShow => 0,
                        TimeLeftShow     => 0,
                        Title            => "some title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 0,
                        VPAIDTimeout     => 0,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    State        => 0,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'some caption',
                    CreateDate   => '2016-07-15 18:06:37',
                    PageOptions  => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    $app->video_an_site->do_action($MOCKED_PAGE_ID, 'start_testing',);

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "example.com",
                    Domain       => "example.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "example.com",
                    PageID       => $MOCKED_PAGE_ID,
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    ProductType  => 'video',
                    RtbVideo     => {
                        Platform          => 'html5',
                        BufferEmptyLimit  => 5,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 5000,
                        SkipDelay        => 0,
                        SkipTimeLeftShow => 0,
                        TimeLeftShow     => 0,
                        Title            => "some title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 0,
                        VPAIDTimeout     => 0,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    State        => 1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'some caption',
                    CreateDate   => '2016-07-15 18:06:37',
                    PageOptions  => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    $app->video_an_site->do_action($MOCKED_PAGE_ID, 'start',);

    is($result, $MOCKED_PAGE_ID, 'got expected Page ID');

    return FALSE;
}

sub create_rtb_block {
    my ($app) = @_;

    note('creating block');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "example.com",
                    Domain       => "example.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "example.com",
                    PageID       => $MOCKED_PAGE_ID,
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    ProductType  => 'video',
                    RtbVideo     => {
                        Platform          => 'html5',
                        BufferEmptyLimit  => 2,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 2000,
                        SkipDelay        => 0,
                        SkipTimeLeftShow => 0,
                        TimeLeftShow     => 0,
                        Title            => "some title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 0,
                        VPAIDTimeout     => 0,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    RtbBlocks => {
                        1 => {
                            AlternativeCode => undef,
                            Article         => isa('SOAP::Data'),
                            BlindLevel      => 0,
                            Brand           => isa('SOAP::Data'),
                            BlockCaption    => 'some video block caption',
                            MultiState      => 6,
                            'DSPInfo'       => [
                                {
                                    'DSPID' => '2563117',
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            'DSPSettings' => {
                                'DSP'         => [2563117],
                                'DSPBindMode' => 'force',
                                'Unmoderated' => []
                            },
                            'MinCPM' => 0,
                            DSPType  => 2,
                            Geo      => isa('SOAP::Data'),
                            page_id  => $MOCKED_PAGE_ID,
                            Video    => {
                                API            => [],
                                CategoryID     => 0,
                                CountPositions => 2,
                                MaxDuration    => 45,
                                Protocols      => [2, 3, 5, 6],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                            AdTypeSet => {
                                'video-motion'      => 1,
                                'video-performance' => 1,
                                'video'             => 1,
                                'media'             => 0,
                                'text'              => 0,
                                'media-performance' => 0
                            },
                            AdType     => isa('SOAP::Data'),
                            AdFoxBlock => 0,
                        },
                    },
                    State        => 1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'some caption',
                    CreateDate   => '2016-07-15 18:06:37',
                    PageOptions  => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site_instream->add(
        get_new_video_instream(
            {
                page_id                   => $MOCKED_PAGE_ID,
                type                      => 1,
                max_duration              => 45,
                count_positions           => 2,
                blind                     => 0,
                dsps                      => [{dsp_id => '2563117'}],
                strategy                  => 3,
                mincpm                    => undef,
                video_active              => 1,
                video_blocked             => 1,
                video_cpm                 => undef,
                video_performance_active  => 1,
                video_performance_blocked => 0,
                video_performance_cpm     => 30,
                alternative_code          => undef,
            }
        )
    );

    cmp_deeply(
        $app->video_an_site_instream->get_all(
            filter => {page_id => $MOCKED_PAGE_ID},
            fields => [qw(page_id id multistate)],
        ),
        [
            {
                id         => 1,
                multistate => '18',              # 2  - working, 16 - need_update
                page_id    => $MOCKED_PAGE_ID,
            },
        ],
        'Got expected multistate from video_an_site_instream->get_all(...)',
    );

    return FALSE;
}

sub check_getting_rtb_block {
    my ($app) = @_;

    my $data = $app->video_an_site_instream->get_all(
        filter => {page_id => $MOCKED_PAGE_ID},
        fields => [qw(page_id id is_custom_bk_data bk_data)],
    );

    cmp_deeply(
        $data,
        [
            {
                bk_data           => undef,
                id                => 1,
                is_custom_bk_data => 0,
                page_id           => $MOCKED_PAGE_ID,
            },
        ],
        'Got expected data'
    );

    my $bk_data = $app->video_an_site_instream->get_bk_data($MOCKED_PAGE_ID);
    cmp_deeply(
        $bk_data,
        {
            '1' => {
                'AdFoxBlock'   => '0',
                'OptimizeType' => 0,
                'AdType'       => {
                    'video-motion' => {
                        'currency' => 'RUB',
                        'value'    => 30000
                    },
                    'video-performance' => {
                        'currency' => 'RUB',
                        'value'    => 30000
                    },
                },
                'AdTypeSet' => {
                    'media'             => 0,
                    'media-performance' => 0,
                    'text'              => 0,
                    'video'             => 0,
                    'video-motion'      => 0,
                    'video-performance' => 0
                },
                'AlternativeCode' => undef,
                'Article'         => {},
                'PICategoryIAB'   => {},
                'BlindLevel'      => '0',
                'BlockModel'      => 'video_an_site_instream',
                'BlockCaption'    => 'Instream',
                'Brand'           => {},
                'DSPInfo'         => [
                    {
                        'CPM'   => 0,
                        'DSPID' => '2563117',
                        'RF'    => {
                            'Interval'   => 0,
                            'ShowsCount' => 0
                        }
                    }
                ],
                'DSPSettings' => {
                    'DSP'         => [2563117],
                    'DSPBindMode' => 'force',
                    'Unmoderated' => []
                },
                'MinCPM'     => 0,
                'DSPType'    => 2,
                'Geo'        => {},
                'MultiState' => '18',
                'Video'      => {
                    'API'            => [],
                    'CategoryID'     => '0',
                    'CountPositions' => '2',
                    'MaxDuration'    => '45',
                    'Protocols'      => [2, 3, 5, 6],
                    'StartTime'      => 0,
                    'Type'           => 'postroll'
                },
                'page_id' => '12345',
                'Sizes'   => [
                    {
                        Width  => 0,
                        Height => 0,
                    }
                ],
                'PageImpOptions' => {
                    'Enable'  => ['allow-multiple-dsp-ads'],
                    'Disable' => []
                },
                'OrderTags'  => [],
                'TargetTags' => [],
            },
        },
        'Got expected "bk_data" data'
    );

    return FALSE;
}

sub set_custom_bk_data_for_block {
    my ($app) = @_;

    note('setting custom bk data for block');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "example.com",
                    Domain       => "example.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "example.com",
                    PageID       => $MOCKED_PAGE_ID,
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    ProductType  => 'video',
                    RtbVideo     => {
                        Platform          => 'html5',
                        BufferEmptyLimit  => 5,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 5000,
                        SkipDelay        => 0,
                        SkipTimeLeftShow => 0,
                        TimeLeftShow     => 0,
                        Title            => "some title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 0,
                        VPAIDTimeout     => 0,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    RtbBlocks => {
                        1 => {
                            a => 1,
                            b => 0,
                        },
                    },
                    State        => 1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'some caption',
                    CreateDate   => '2016-07-15 18:06:37',
                    PageOptions  => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site_instream->do_action(
        "R-V-$MOCKED_PAGE_ID-1",
        'edit',
        is_custom_bk_data => 1,
        bk_data           => '{ "a" : 1, "b" : 0 }',
    );

    my $data = $app->video_an_site_instream->get_all(
        fields => [qw(page_id id is_custom_bk_data bk_data)],
        filter => {page_id => $MOCKED_PAGE_ID},
    );

    cmp_deeply(
        $data,
        [
            {
                bk_data => '{
   "a" : 1,
   "b" : 0
}
',
                id                => 1,
                is_custom_bk_data => 1,
                page_id           => $MOCKED_PAGE_ID,
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub cant_edit_rtb_block_with_flag_is_custom_bk_data {
    my ($app) = @_;

    note('Trying to edit block with is_custom_bk_data = 1');

    my $err;
    try {
        my $result = $app->video_an_site_instream->do_action("R-V-$MOCKED_PAGE_ID-1", 'edit',
            AlternativeCode => 'console.log("test");',);
    }
    catch {
        $err = $_[0];
    };

    ok($err, "Can't edit block with is_custom_bk_data = 1");

    return FALSE;
}

sub check_bk_data_must_be_json {
    my ($app) = @_;

    note("Cheking that one can't use sting instead of json for bk_data");

    my $err;
    try {
        my $result = $app->internal_context_on_site_rtb->do_action("R-V-$MOCKED_PAGE_ID-1", 'edit', bk_data => 'asdf',);
    }
    catch {
        $err = $_[0];
    };

    ok($err, "Can't set incorrect bk_data for block");

    my $data = $app->video_an_site_instream->get_all(
        fields => [qw(page_id id is_custom_bk_data bk_data)],
        filter => {page_id => $MOCKED_PAGE_ID},
    );

    cmp_deeply(
        $data,
        [
            {
                bk_data => '{
   "a" : 1,
   "b" : 0
}
',
                id                => 1,
                is_custom_bk_data => 1,
                page_id           => $MOCKED_PAGE_ID,
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub check_switch_off_is_custom_bk_data {
    my ($app) = @_;

    note('switching is_custom_bk_data off');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        cmp_deeply(
            $data,
            {
                0 => {
                    Description  => "example.com",
                    Domain       => "example.com",
                    IsYandexPage => 0,
                    Mirrors      => "yastatic.net",
                    Name         => "example.com",
                    PageID       => $MOCKED_PAGE_ID,
                    PartnerID    => 11010,
                    Places       => ignore(),
                    PPCTotal     => 9,
                    ProductType  => 'video',
                    RtbVideo     => {
                        Platform          => 'html5',
                        BufferEmptyLimit  => 5,
                        BufferFullTimeout => 500,
                        Categories        => {
                            0 => {
                                Archive => 0,
                                Name    => re(qr(\w)),
                            },
                        },
                        Contents => ignore(),
                        #                        RF       => {
                        #                            Interval   => 604800,
                        #                            ShowsCount => 25,
                        #                        },
                        Skin             => "http://storage.mds.yandex.net/get-partner/14408/default.swf",
                        SkinTimeout      => 5000,
                        SkipDelay        => 0,
                        SkipTimeLeftShow => 0,
                        TimeLeftShow     => 0,
                        Title            => "some title",
                        VASTTimeout      => 500,
                        VideoTimeout     => 500,
                        VPAIDEnabled     => 0,
                        VPAIDTimeout     => 0,
                        WrapperMaxCount  => 3,
                        WrapperTimeout   => 1000,
                    },
                    RtbBlocks => {
                        1 => {
                            AlternativeCode => undef,
                            Article         => isa('SOAP::Data'),
                            BlindLevel      => 0,
                            Brand           => isa('SOAP::Data'),
                            BlockCaption    => 'some video block caption',
                            MultiState      => 18,
                            'DSPInfo'       => [
                                {
                                    'DSPID' => '2563117',
                                    'RF'    => {
                                        'Interval'   => 0,
                                        'ShowsCount' => 0
                                    },
                                    'CPM' => 0
                                }
                            ],
                            DSPType => 2,
                            Geo     => isa('SOAP::Data'),
                            page_id => $MOCKED_PAGE_ID,
                            Video   => {
                                API            => [],
                                CategoryID     => 0,
                                CountPositions => 2,
                                MaxDuration    => 45,
                                Protocols      => [2, 3, 5, 6],
                                StartTime      => 0,
                                Type           => "postroll",
                            },
                            AdTypeSet => {
                                'video-motion'      => 1,
                                'video-performance' => 1,
                                'video'             => 1,
                                'media'             => 0,
                                'text'              => 0,
                                'media-performance' => 0
                            },
                            AdType     => isa('SOAP::Data'),
                            AdFoxBlock => 0,
                        },
                    },
                    State        => 1,
                    TargetType   => 3,
                    BusinessUnit => 0,
                    isPi2        => 1,
                    ProductID    => 'video_an_site',
                    Login        => 'mocked-video-partner',
                    PageCaption  => 'some caption',
                    CreateDate   => '2016-07-15 18:06:37',
                    PageOptions  => {Enable => [], Disable => [],},
                },
            },
            'Sending expected data to BK',
        );

        return FALSE;
    };

    my $result = $app->video_an_site_instream->do_action("R-V-$MOCKED_PAGE_ID-1", 'edit', is_custom_bk_data => 0);

    return FALSE;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_balance($app);
        mock_agreement_checker($app);
        mock_curdate('2016-07-15 18:06:37');
        mock_utils_partner2($app);

        create_video_an_site($app);
        create_rtb_block($app);
        check_getting_rtb_block($app);
        set_custom_bk_data_for_block($app);
        cant_edit_rtb_block_with_flag_is_custom_bk_data($app);
        check_bk_data_must_be_json($app);
        check_switch_off_is_custom_bk_data($app);

    },
    locale => 'en',
    init   => [qw(api_bk api_balance)],
);
