#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

use PiConstants qw(
  $VIDEO_PLATFORM_FLASH
  $VIDEO_PLATFORM_HTML5
  $VIDEO_PLATFORM_MOBILE
  $VIDEO_PLATFORM_SMART_TV
  );

run_tests(
    sub {
        my ($app) = @_;

        my $tests = [
            (
                map {+{vpaid_enabled => 0, platform => $_, result => []}}
                  ($VIDEO_PLATFORM_FLASH, $VIDEO_PLATFORM_HTML5, $VIDEO_PLATFORM_MOBILE, $VIDEO_PLATFORM_SMART_TV)
            ),
            {vpaid_enabled => 1, platform => $VIDEO_PLATFORM_FLASH, result => [2]},
            {vpaid_enabled => 1, platform => $VIDEO_PLATFORM_HTML5, result => [2, 3]},
            map {+{vpaid_enabled => 1, platform => $_, result => [3]}}
              ($VIDEO_PLATFORM_MOBILE, $VIDEO_PLATFORM_SMART_TV)
        ];

        my @accessors = get_accessors($app);

        foreach my $accessor (@accessors) {
            foreach my $test (@$tests) {
                cmp_deeply(
                    $app->$accessor->get_api_frameworks(
                        vpaid_enabled => $test->{'vpaid_enabled'},
                        platform      => $test->{'platform'},
                    ),
                    $test->{'result'},
                    "$accessor: vpaid_enabled = $test->{vpaid_enabled}, platform = $test->{platform}"
                );
            }
        }
    },
    dont_create_database => TRUE,
);

sub get_accessors {
    my ($app) = @_;

    return grep {Scalar::Util::blessed($app->{$_}) && $app->$_->isa('Application::Model::Block::Video')} keys(%$app);
}
