#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @accessors = get_accessors($app);

        foreach my $accessor (@accessors) {
            cmp_deeply($app->$accessor->get_protocols(2), [2, 5], "$accessor: vast version - 2");

            cmp_deeply($app->$accessor->get_protocols(3), [2, 3, 5, 6], "$accessor: vast version - 3");
        }
    },
    dont_create_database => TRUE,
);

sub get_accessors {
    my ($app) = @_;

    return grep {Scalar::Util::blessed($app->{$_}) && $app->$_->isa('Application::Model::Block::Video')} keys(%$app);
}
