#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $type_error = {'allow_multiple_dsp_ads' => ['Expected type boolean']};

        my $adfox_error = {'allow_multiple_dsp_ads' => ['Can\'t create adfox block with allow_multiple_dsp_ads']};

        my $data;
        foreach (
            [0, -1,    $type_error,  'non boolean value 1'],
            [0, 2,     $type_error,  'non boolean value 2'],
            [0, undef, undef,        'optional value'],
            [0, 0,     undef,        'false value'],
            [0, 1,     undef,        'true value'],
            [1, 0,     undef,        'false value with adfox_block'],
            [1, 1,     $adfox_error, 'true value with adfox_block'],
          )
        {

            my ($adfox, $value, $expect_errors, $test_name) = @$_;

            $data->{'adfox_block'}            = $adfox;
            $data->{'allow_multiple_dsp_ads'} = $value;
            $data->{'type'}                   = 0;

            my $_stash = $app->video_an_site_instream->hook_stash->init(
                mode => 'edit',
                data => {current => {}, opts => $data},
                $app->video_an_site_instream->hook_stash_edit_fields,
            );

            $data = $app->video_an_site_instream->hook_fields_processing_before_validation($data);

            my $qv = QBit::Validator->new(
                data => $data,
                app  => $app->video_an_site_instream,
                $app->video_an_site_instream->get_template(fields => [qw(adfox_block allow_multiple_dsp_ads)]),
            );

            my @errors     = $qv->get_fields_with_error();
            my $got_errors = _get_erros(\@errors);

            if ($expect_errors) {
                my $is_ok = cmp_deeply($got_errors, $expect_errors, $test_name);
                warn Data::Dumper->Dump([$got_errors], ['$got_errors ' . __PACKAGE__ . ':' . __LINE__]) unless $is_ok;
            } else {
                my $is_ok = is($qv->has_errors, FALSE, $test_name);
                warn Data::Dumper->Dump([$got_errors], ['$got_errors ' . __PACKAGE__ . ':' . __LINE__]) unless $is_ok;
            }
        }
    },
);

sub _get_erros {
    my ($errors) = @_;

    my $res = {
        # <path> => [ 'msg1', ... ]
    };
    foreach my $row (@$errors) {
        my $key = join '.', @{$row->{path}};
        my $ar = $res->{$key} //= [];

        # ARRAY(0xf175be0) -> ARRAY(0xFFFFFF)
        push @$ar, map {s/\(0x[^)]+\)/(0xFFFFFF)/g; $_} @{$row->{msgs}};
    }

    return $res;
}
