#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_bag);
use qbit;

sub check_model {
    my ($app, $model) = @_;

    my $page_id_field = $app->$model->get_page_id_field_name();

    my $expected = $app->$model->get_all(fields => [$page_id_field, qw(public_id id)]);

    if (not @$expected) {
        warn "Skipping model '$model', because it hasn't any element in mocked_db";
        return;
    }

    # ok(scalar @$expected, "model '$model' has at least one element");
    my @got;

    for my $block (@$expected) {
        my $public_id = $block->{public_id};
        my $got = $app->$model->get($public_id, fields => [$page_id_field, qw(public_id id)]);
        last if $public_id ne $got->{public_id};
        push @got, $got;
    }

    cmp_bag($expected, \@got, "model '$model' correctly returns block by public_id");

    return;
}

run_tests(
    sub {
        my ($app) = @_;

        my @block_models = grep {blessed($app->{$_}) and $app->$_->isa('Application::Model::Block')} keys %$app;

        for my $model (@block_models) {
            check_model($app, $model);
        }

        return;
    },
);
