#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

use qbit;

my %IGNORE_BLOCKS = map {$_ => 1} qw(
  context_on_site_natural
  internal_context_on_site_natural
  internal_context_on_site_content
  );

run_tests(
    sub {
        my ($app) = @_;

        foreach my $block_accessor (sort @{$app->product_manager->get_block_model_accessors()}) {
            subtest "check $block_accessor" => sub {

                can_ok($app->$block_accessor, 'on_action_duplicate');

                if (
                    (
                           $app->$block_accessor->isa('RestApi::SimpleModel')
                        || $app->$block_accessor->isa('RestApi::DBModel')
                        || $app->$block_accessor->isa('RestApi::MultistateModel')
                    )
                    && !$IGNORE_BLOCKS{$block_accessor}
                   )
                {

                    can_ok($app->$block_accessor, 'api_available_actions');

                    my $has_dup = scalar(grep {'duplicate' eq $_} $app->$block_accessor->api_available_actions());
                    isnt($has_dup, 0, "ok $block_accessor - duplicate available");

                } else {
                    diag("$block_accessor is not available thru RestAPI");
                }

            };
        }
    },
    do_not_die_on_fail => 1
);
