use qbit;

use Test::Partner2::Simple;
use Test::More tests => 16;
use Test::Exception;
use Test::Partner2::Mock;
use Test::Partner::Utils;

run_tests(
    sub {
        my ($app) = @_;
        mock_bk($app);
        mock_format_system($app);
        mock_utils_partner2($app);
        mock_yt_picategory_mapping($app);
        @PiConstants::VIDEO_AWAPS_DSPS = (1, 2563117);

        change_cur_user($app, 'mocked-yan-manager');

        my $id = $app->context_on_site_campaign->add(
            domain_id => 2,
            caption   => 'campaign',
            login     => 'mocked-yan-partner'
        );
        my $page_id = $app->context_on_site_campaign->get($id, fields => [qw(page_id)])->{page_id};

        my $block_id =
          $app->context_on_site_rtb->add(%{get_new_an_rtb({campaign_id => $page_id, dsps => ['1', '2317563']})});

        # custom_bk_data = 0
        my ($available_fields, $editable_fields) =
          @{$app->context_on_site_rtb->get($block_id, fields => [qw(available_fields editable_fields)])}
          {qw(available_fields editable_fields)};
        ok($available_fields->{is_custom_bk_data}, 'available_fields is_custom_bk_data godmode disabled');
        ok($available_fields->{bk_data},           'available_fields bk_data godmode disabled');
        ok($editable_fields->{is_custom_bk_data},  'editable_fields bk_data godmode disabled');
        ok(!$editable_fields->{bk_data},           'editable_fields bk_data godmode disabled');
        my $bk_data =
          {$app->context_on_site_rtb->get_bk_data($page_id)}->{$app->context_on_site_rtb->get_bk_block_data_key()};
        is($bk_data->{1}{BlockModel}, 'context_on_site_rtb', 'bk_data godmode disabled');

        # enable custom_bk_data
        $app->context_on_site_rtb->do_action(
            $block_id, 'edit',
            is_custom_bk_data => 1,
            bk_data           => '{"RtbDesign":"\"fake_key\":\"fake_value\""}'
        );

        # custom_bk_data = 1
        ($available_fields, $editable_fields) =
          @{$app->context_on_site_rtb->get($block_id, fields => [qw(available_fields editable_fields)])}
          {qw(available_fields editable_fields)};
        ok($available_fields->{is_custom_bk_data}, 'available_fields is_custom_bk_data godmode enabled');
        ok($available_fields->{bk_data},           'available_fields bk_data godmode enabled');
        is_deeply(
            $editable_fields,
            {
                is_custom_bk_data => 1,
                bk_data           => 1,
            },
            'editable_fields godmode enabled'
        );
        $bk_data =
          {$app->context_on_site_rtb->get_bk_data($page_id)}->{$app->context_on_site_rtb->get_bk_block_data_key()};
        is_deeply($bk_data->{1}, {RtbDesign => '"fake_key":"fake_value"'}, 'design godmode enabled');

        # try edit custom_bk_data with incorrect design_id
        throws_ok {
            $app->context_on_site_rtb->do_action(
                $block_id, 'edit',
                is_custom_bk_data => 1,
                bk_data           => '{"RtbDesign":{"12345":{"fake_key":"fake_value"}}}'
            );
        }
        'Exception::Validator::Errors';

        change_cur_user($app, 'mocked-yan-partner');

        # try disable custom_bk_data as a partner
        throws_ok {
            $app->context_on_site_rtb->do_action($block_id, 'edit', is_custom_bk_data => 0);
        }
        'Exception::Multistate::BadAction';

        # check access as a partner
        ($available_fields, $editable_fields) =
          @{$app->context_on_site_rtb->get($block_id, fields => [qw(available_fields editable_fields)])}
          {qw(available_fields editable_fields)};
        ok($available_fields->{is_custom_bk_data}, 'available_fields is_custom_bk_data godmode enabled as partner');
        ok(!$available_fields->{bk_data},          'available_fields is_custom_bk_data godmode enabled as partner');
        is_deeply($editable_fields, {}, 'editable_fields godmode enabled as partner');
    },
);
