use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use Test::More tests => 3;
use Test::Exception;
use Test::Partner2::Mock;

my $block_fixture    = 'partner_context_rtb_block_with_design_templates';
my $expected_bk_data = '{
   "RtbDesign" : "\"fake_key\":\"fake_value\""
}
';

run_tests(
    sub {
        my ($app) = @_;
        mock_bk($app);
        mock_yt_picategory_mapping($app);

        my $rtb_block = get_fixture($block_fixture);
        my $page_id   = $rtb_block->{'campaign_id'};
        $app->context_on_site_campaign->do_action($page_id, 'set_need_update');

        my $origin_get_bk_block_data = \&Application::Model::Product::AN::ContextOnSite::RTB::get_bk_block_data;
        {
            no warnings 'redefine';
            no strict 'refs';
            *{'Application::Model::Product::AN::ContextOnSite::RTB::get_bk_block_data'} = sub {
                my ($self, $block) = @_;
                $app->context_on_site_rtb->do_action(
                    $rtb_block, 'edit',
                    is_custom_bk_data => 1,
                    bk_data           => $expected_bk_data,
                );
                return $origin_get_bk_block_data->($self, $block);
            };
        }
        $app->context_on_site_campaign->update_in_bk({page_id => $page_id});

        my $updated_bk_data = $app->context_on_site_rtb->get($rtb_block, fields => [qw(bk_data)])->{'bk_data'};
        is_deeply($updated_bk_data, $expected_bk_data, 'bk_data is not overwritten');
    },
    fill_databases => 0,
    fixtures       => [$block_fixture, 'tns_dict_article', 'picategories_dict'],
);
