#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk mock_agreement_checker);

use Test::More;
use Test::Deep;

use qbit;

my $DATA = [
    # РЕКЛАМА НА САЙТАХ
    {
        testname => 'РЕКЛАМА НА САЙТАХ. RTB-Блок',
        model    => 'context_on_site_rtb',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 41443, id => 1},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Direct-Блок',
        model    => 'context_on_site_direct',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 142898, id => 2},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Stripe-Блок',
        model    => 'context_on_site_stripe',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 41443, id => 40},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Спецразмещение',
        model    => 'search_on_site_premium',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 111161, id => 2},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Поисковый Блок',
        model    => 'search_on_site_direct',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 111161, id => 1},
    },
    # СЕРВИСЫ ЯНДЕКСА
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Direct-Блок',
        model    => 'internal_context_on_site_direct',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 88849, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. RTB-Блок',
        model    => 'internal_context_on_site_rtb',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 88848, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Stripe-Блок',
        model    => 'internal_context_on_site_stripe',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 2, id => 1},
    },
    ## РЕКЛАМА В ПРИЛОЖЕНИЯХ
    {
        testname => 'РЕКЛАМА В ПРИЛОЖЕНИЯХ. RTB-Блок',
        model    => 'mobile_app_rtb',
        login    => 'mocked-mobile-app-partner',
        id       => {campaign_id => 43569, id => 1},
    },
    # РЕКЛАМА В ВИДЕО
    {
        testname => 'РЕКЛАМА В ВИДЕО. InPage-Блок',
        model    => 'video_an_site_inpage',
        login    => 'mocked-video-partner',
        id       => {page_id => 154689, id => 1},
    },
    {
        testname => 'РЕКЛАМА В ВИДЕО. InStream-Блок',
        model    => 'video_an_site_instream',
        login    => 'mocked-video-partner',
        id       => {page_id => 154689, id => 2},
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_agreement_checker($app);

        $Data::Dumper::Terse  = 1;
        $Data::Dumper::Indent = 0;

        #########
        foreach my $testdata (@$DATA) {
            my ($login, $model, $id, $testname) = @$testdata{qw( login  model  id  testname )};

            change_cur_user($app, $login);

            subtest(
                $testname => sub {

                    _check_status($app, $model, $id, ['delete', 'restore']);

                }
            );
        }

        ########

    },
    do_not_die_on_fail => 1
);

sub _check_status {
    my ($app, $model, $id, $set_statuses) = @_;

    # Чтобы не было проблем с графом статусов
    $app->$model->partner_db_table()->edit($id, {multistate => 0});

    # Подводим к нужному статусу
    map {$app->$model->force_do_action($id, $_)} @$set_statuses;

    # Проверяем отсутствие флага 'deleted'
    _check_multistate($app, $model, $id, $set_statuses->[-1], FALSE);
}

sub _check_multistate {
    my ($app, $model, $id, $after_action, $expect) = @_;

    my $expect_status = 'not deleted';

    # Проверяем статус
    my $multiistate = $app->$model->get($id, fields => ['multistate'])->{'multistate'};
    my $got = $app->$model->check_multistate_flag($multiistate, $expect_status);

    my $no = $expect ? 'got' : 'has no';
    is(
        $got, $expect,
        sprintf(
            'id=%s, multistate=%d (%s) %s flag "%s" after action "%s"',
            Dumper($id), $multiistate, $model, $no, $expect_status, $after_action
        )
      );

}
