#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Fixture;

use Test::More;
use Test::Deep;
use Test::Exception;

use qbit;

use lib::abs;

use Test::Partner::Utils qw(use_common_blocks_table);

my @dsp_fixtures = ('dsp_direct', 'dsp_media', 'dsp_media_video_mobile', 'dsp_mobile',);

my @block_fixtures = (
    'partner_context_rtb_block',                 'partner_context_rtb_vip_block',
    'partner_context_rtb_block_with_show_video', 'partner_mobile_native_rtb_block',
    'partner_mobile_rewarded_rtb_block',
);

run_tests(
    sub {
        my ($app) = @_;

        my $blocks = get_fixtures_hash(@block_fixtures);
        my $dsps   = get_fixtures_hash(@dsp_fixtures);

        use_common_blocks_table($app);

        lives_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block},
                'edit', dsps => dsps_to_ids($dsps, 'dsp_media', 'dsp_media_video_mobile'));
        }
        'ok dsps';

        throws_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block}, 'edit', dsps => []);
        }
        'Exception::Validator::Errors';

        throws_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_vip_block}, 'edit', dsps => []);
        }
        'Exception::Validator::Errors';

        dies_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block},
                'edit', dsps => dsps_to_ids($dsps, 'dsp_media', 'dsp_media'));
        }
        'duplicates dies';
        like($@->message, qr/DSP's with ID .* duplicate/, 'duplicates message');

        lives_ok {
            $app->mobile_app_rtb->do_action($blocks->{partner_mobile_native_rtb_block},
                'edit', dsps => dsps_to_ids($dsps, 'dsp_mobile'));
        }
        'native non-direct dsp now not dies';

        lives_ok {
            $app->mobile_app_rtb->do_action($blocks->{partner_mobile_rewarded_rtb_block}, 'edit', dsps => []);
        }
        'empty dsps list lives';

        dies_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block_with_show_video},
                'edit', dsps => dsps_to_ids($dsps, 'dsp_media'));
        }
        'no video dsps dies';
        like($@->message, qr/Choose DSP for Video ad/, 'no video dsps message');

        lives_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block_with_show_video},
                'edit', dsps => dsps_to_ids($dsps, 'dsp_direct'));
        }
        'direct dsp as video dsp lives';

        dies_ok {
            $app->context_on_site_rtb->do_action($blocks->{partner_context_rtb_block}, 'edit', dsps => [123123123123]);
        }
        'not found dies';
        like($@->message, qr/DSP's with ID .* not found/, 'not found message');
    },
    fill_databases => 0,
    fixtures       => [@dsp_fixtures, @block_fixtures,],
);

sub dsps_to_ids {
    my ($dsps, @names) = @_;
    return [map {$dsps->{$_}{id}} @names];
}
