#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use Test::Partner::Utils qw(use_common_blocks_table);

use Test::More;
use Test::Deep;

use qbit;

use lib::abs;

my @dsp_fixtures = (
    qw(
      dsp_direct
      dsp_awaps_video_auction
      dsp_awaps_video_auction_in_banner
      dsp_awaps_video_in_banner
      dsp_video_interstitial_mobile_10
      dsp_video_interstitial_mobile_7
      dsp_video_interstitial_mobile_12
      )
);
my %block_fixtures = (
    'partner_context_rtb_block'                 => {model => 'context_on_site_rtb',},
    'partner_context_rtb_block_with_show_video' => {model => 'context_on_site_rtb',},
    'partner_context_adblock_block'             => {model => 'context_on_site_adblock',},
    'internal_context_rtb_block'                => {model => 'internal_context_on_site_rtb',},
    'partner_mobile_banner_rtb_block'           => {model => 'mobile_app_rtb',},
    'partner_mobile_interstitial_rtb_block'     => {model => 'mobile_app_rtb',},
    'internal_mobile_banner_rtb_block'          => {model => 'internal_mobile_app_rtb',},
    'internal_mobile_interstitial_rtb_block'    => {model => 'internal_mobile_app_rtb',},
);

my %dsp_name_by_id;

run_tests(
    sub {
        my ($app) = @_;

        my $dsps   = get_fixtures_hash(@dsp_fixtures);
        my $blocks = get_fixtures_hash(keys %block_fixtures);

        for my $dsp (@dsp_fixtures) {
            $dsp_name_by_id{$dsps->{$dsp}{id}} = $dsp;
        }

        use_common_blocks_table($app);

        my $file = lib::abs::path('edit_show_video.json');

        unless (-e $file) {
            writefile($file, '{}');
        }

        my $expected_data = from_json(readfile($file));
        my $got_data      = {};

        for my $block_name (keys(%$blocks)) {
            for my $show_video (1, 0) {
                my $block = $blocks->{$block_name};
                my $dsps;
                my $model = $block_fixtures{$block_name}{model};
                $app->$model->do_action($block, 'edit', show_video => $show_video);
                $dsps = [map {$dsp_name_by_id{$_}} @{$app->$model->get($block, fields => [qw(dsps)])->{dsps}}];
                my $subkey = "show_video = $show_video";
                $got_data->{$block_name}{$subkey} = $dsps;
                cmp_deeply(
                    $got_data->{$block_name}{$subkey},
                    bag(@{$expected_data->{$block_name}{$subkey}}),
                    join(', ', $block_name, $subkey)
                ) unless need_self_update();
            }
        }

        if (need_self_update()) {
            writefile($file, to_json($got_data, pretty => TRUE));
            fail('self update mode');
        }
    },
    fill_databases => 0,
    fixtures       => [keys %block_fixtures, 'special_dsps', @dsp_fixtures],
);
