#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::More;
use Test::Deep;
use Test::Exception;

use qbit;

use PiConstants qw(
  $TECHNICAL_RTB_BLOCK_ID
  $WWWODNOKLASSNIKI_USER_ID
  );

run_tests(
    sub {
        my ($app) = @_;

        my %opts;

        my $block = {
            page         => {owner_id => 1},
            direct_block => '',
            id           => 1,
            ex_direct    => 0
        };

        my @tests = (
            {
                block => {block_type => 'rewarded',},
                opts  => {},
            },
            {
                block => {
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 1,
                    text_active   => 1,
                    text_blocked  => 1,
                    text_cpm      => 1,
                    video_active  => 1,
                    video_blocked => 1,
                    video_cpm     => 1,
                },
                opts => {},
            },
            {
                block => {show_video => 1,},
                opts  => {
                    media                   => 0,
                    allow_media_performance => 0,
                },
            },
            {
                block => {show_video => 1,},
                opts  => {
                    media                   => 0,
                    allow_media_performance => 1,
                },
            },
            {
                block => {show_video              => 1,},
                opts  => {allow_media_performance => 0,},
            },
            {
                block => {show_video => 1,},
                opts  => {
                    media                   => 1,
                    allow_media_performance => 1,
                },
            },
            {
                block => {show_video => 0,},
                opts  => {
                    media                   => 1,
                    allow_media_performance => 1,
                },
            },
            {
                model => 'context_on_site_rtb',
                block => {show_video => 0,},
                opts  => {
                    media                   => 1,
                    allow_media_performance => 1,
                },
            },
            {
                model => 'context_on_site_rtb',
                block => {show_video => 1,},
                opts  => {
                    media                   => 1,
                    allow_media_performance => 1,
                },
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 0,
                    media_blocked => 0,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 0,
                    media_blocked => 0,
                    media_cpm     => 0,
                    text_active   => 1,
                    text_blocked  => 1,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 1,
                    media_blocked => 0,
                    media_cpm     => 11,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 0,
                    media_blocked => 0,
                    media_cpm     => 0,
                    text_active   => 1,
                    text_blocked  => 0,
                    text_cpm      => 22,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    media_active  => 1,
                    media_blocked => 0,
                    media_cpm     => 11,
                    text_active   => 1,
                    text_blocked  => 0,
                    text_cpm      => 22,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    video_active  => 1,
                    video_blocked => 0,
                    video_cpm     => 33,
                },
                opts => {},
            },
            {
                block => {
                    show_video    => 1,
                    video_active  => 1,
                    video_blocked => 0,
                    video_cpm     => 44,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    page          => {owner_id => 1},
                    direct_block  => '100x100',
                    id            => 1,
                    ex_direct     => 0,
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    page          => {owner_id => $WWWODNOKLASSNIKI_USER_ID},
                    direct_block  => '100x100',
                    id            => 1,
                    ex_direct     => 0,
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_rtb',
                block => {
                    id            => $TECHNICAL_RTB_BLOCK_ID,
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'internal_context_on_site_rtb',
                block => {
                    id            => $TECHNICAL_RTB_BLOCK_ID,
                    media_active  => 1,
                    media_blocked => 1,
                    media_cpm     => 0,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            },
            {
                model => 'context_on_site_content',
                block => {
                    id            => $TECHNICAL_RTB_BLOCK_ID,
                    media_active  => 1,
                    media_blocked => 0,
                    media_cpm     => 33,
                    text_active   => 0,
                    text_blocked  => 0,
                    text_cpm      => 0,
                },
                opts => {},
            }
        );

        my @got;
        for my $test (@tests) {
            my $BK_DATA = {};
            my $model = $test->{model} // 'mobile_app_rtb';

            try {
                $app->$model->get_ad_type_set($BK_DATA, {%$block, %{$test->{block}}}, %{$test->{opts}});
                push @got, $BK_DATA;
            }
            catch {
                push @got, $_[0]->message;
            };

        }

        my $expected = get_test_data_and_update_if_needed('bk_data_ad_type_set.json', \@got);

        cmp_deeply(\@got, $expected);

    },
    application_package => 'Application',
);
