use qbit;

use Test::Partner2::Simple;
use Test::More;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    sub {
        my ($app) = @_;

        my $models = {
            mobile_app_rtb => {
                login    => 'smaato',
                expected => []
            },
            context_on_site_rtb => {
                login    => 'mocked-yan-partner',
                expected => []
            },
        };

        for my $model (keys %$models) {
            change_cur_user($app, $models->{$model}{login});
            $models->{$model}{expected} = $app->$model->get_all_applications_for_adding();
        }

        my $expected = get_test_data_and_update_if_needed('data.json', $models);
        is_deeply($models, $expected, 'get_all_campaigns_for_adding with on moderation OK');

    },
);
