#!/usr/bin/perl -w

use warnings FATAL => 'all';
use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Utils qw($SKIP_MODELS);
use Test::Differences;

use Test::Partner2::Fixture;
use Test::Partner2::Fixture::DB::Page;

use Test::More;    # tests => 272;

my %FIX = (
    context_page_fixture => {
        owner_fixture_name  => 'mocked_yan_partner',
        source_fixture_name => 'partner_site',
    },
    search_page_fixture => {
        owner_fixture_name  => 'mocked_yan_partner',
        source_fixture_name => 'partner_site',
    },
    mobile_page_fixture => {
        owner_fixture_name  => 'mocked_mobile_app_partner',
        source_fixture_name => 'partner_mobile_app',
    },
    video_page_fixture => {
        owner_fixture_name => 'mocked_video_partner',
        domain             => 'mocked.video.site.ru',
        multistate         => 1,
    },
    indoor_page_fixture => {
        owner_fixture_name => 'mocked_indoor_partner',
        opts               => {domain => 'mocked.indoor.video.site.ru',},
        multistate         => 385 + 1024,                                   # + approved
    },
    outdoor_page_fixture => {
        owner_fixture_name => 'mocked_outdoor_partner',
        opts               => {domain => 'mocked.outdoor.video.site.ru',},
    },
    internal_mobile_page_fixture => {
        creator_fixture_name   => 'mocked_internal_administrator',
        managers_fixture_names => [qw(mocked_internal_manager)],
        store_id               => 'com.internal.mobile.app',
        creator_fixture_name   => 'mocked_internal_manager',
    },
    internal_context_page_fixture => {
        creator_fixture_name   => 'mocked_internal_administrator',
        managers_fixture_names => [qw(mocked_internal_manager)],
        source_fixture_name    => 'internal_site',
        creator_fixture_name   => 'mocked_internal_manager',
    },
    internal_search_page_fixture => {
        creator_fixture_name   => 'mocked_internal_administrator',
        managers_fixture_names => [qw(mocked_internal_manager)],
        source_fixture_name    => 'internal_site',
        creator_fixture_name   => 'mocked_internal_manager',
    },
);

run_tests(
    sub {
        my ($app) = @_;

        my (%blocks, %pages);
        for my $block_accessor (grep {!/^ssp/} @{$app->product_manager->get_block_model_accessors}) {
            next if $SKIP_MODELS->{$block_accessor};

            my $block_model = $app->$block_accessor;
            next unless $block_model->can('get_fields_defaults');
            next unless $block_model->can('get_campaign_model_name');
            my $page_accessor = $block_model->get_campaign_model_name;
            $blocks{$block_accessor} = TRUE;
            $pages{$page_accessor}   = TRUE;
        }

        my @page_list;
        for my $page_accessor (sort keys %pages) {
            push @page_list, $page_accessor,
              $app->$page_accessor->get_all(fields => ['page_id', ($page_accessor =~ /^internal/ ? () : ('caption'))]);
        }
        my $has_page_list = get_test_data_and_update_if_needed("page_list.json", \@page_list);
        eq_or_diff($has_page_list, \@page_list, "check page_list");

        for my $block_accessor (sort keys %blocks) {
            my %data;
            my $add_fields;
            try {
                $add_fields = $app->$block_accessor->get_add_fields;
                my @skip_fields = keys %{$app->$block_accessor->get_fields_depends->{required}};
                delete @$add_fields{@skip_fields};
                delete $add_fields->{$app->$block_accessor->get_page_id_field_name};
                $add_fields->{page_id} = TRUE;
            }
            catch {
                $add_fields = {page_id => TRUE};
            };
            my @add_fields = sort grep {$add_fields->{$_}} keys %$add_fields;
            $data{add_fields} = \@add_fields;

            $data{full} = $app->$block_accessor->get_fields_defaults(
                {attributes => {}, fields => \@add_fields, changed_fields => []});
            $data{limit} = $app->$block_accessor->get_fields_defaults(
                {attributes => {}, fields => \@add_fields, changed_fields => [], page_limit => 2});
            $data{filter} = $app->$block_accessor->get_fields_defaults(
                {
                    attributes     => {},
                    fields         => \@add_fields,
                    changed_fields => [],
                    page_limit     => 2,
                    page_filter    => ['caption', 'LIKE', '1'],
                }
            ) unless $block_accessor =~ /^internal/;

            $data{sort_asc} = $app->$block_accessor->get_fields_defaults(
                {
                    attributes     => {},
                    fields         => [qw(page_id)],
                    changed_fields => [],
                    page_limit     => 2,
                    page_sort      => ['caption', 'page_id'],
                }
            );

            $data{sort_desc} = $app->$block_accessor->get_fields_defaults(
                {
                    attributes     => {},
                    fields         => [qw(page_id)],
                    changed_fields => [],
                    page_limit     => 2,
                    page_sort      => [['caption', 1], ['page_id', 1]],
                }
            );

            my $has_fd = get_test_data_and_update_if_needed("$block_accessor.json", \%data);
            eq_or_diff(from_json(to_json(\%data)), $has_fd, "check $block_accessor");
        }

    },
    do_not_die_on_fail => 1,
    fill_databases     => 0,
    extra_fixtures     => make_fixtures(3),
);

sub make_fixtures {
    my ($count) = @_;
    my @fixtures;
    for my $m (sort keys %FIX) {
        my $p   = $FIX{$m};
        my $sub = Test::Partner2::Fixture::DB::Page->can($m);
        for my $c (1 .. $count) {
            my $name = $m . '_' . $c;
            push @fixtures, $sub->(%$p, fixture_name => $name, ($m =~ /^internal/ ? () : (caption => 'c' . $c)));
        }
    }
    return +{@fixtures};
}
