#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Utils qw($SKIP_MODELS);

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        foreach my $block_model (sort @{$app->product_manager->get_block_model_names()}) {
            next if $SKIP_MODELS->{$block_model};

            next unless $app->$block_model->DOES('Application::Model::Role::Has::Strategies');

            my $fixtures = get_test_data_and_update_if_needed("$block_model.json");

            my @tests = ();
            foreach my $fixture (@$fixtures) {
                my $strategies = $app->$block_model->get_types_strategies($fixture->{'args'});

                push(@tests, [$strategies, $fixture->{'expected'}, $fixture->{'name'}]);

                $fixture->{'expected'} = $strategies;
            }

            get_test_data_and_update_if_needed("$block_model.json", $fixtures);

            foreach (@tests) {
                cmp_deeply(@$_);
            }
        }
    },
    application_package => 'Application',
    do_not_die_on_fail  => 1,
);
