#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(ignore cmp_deeply bag);
use qbit;

sub check_model {
    my ($app, $model) = @_;

    my $page_id_field = $app->$model->get_page_id_field_name();

    my $all = $app->$model->get_all(fields => [$page_id_field, qw(id)]);

    if (not @$all) {
        warn "Skipping model '$model', because it hasn't any element in mocked_db";
        return;
    }

    # ok(scalar @$all, "model '$model' has at least one element");

    my $max_page_id = [sort {$b <=> $a} map {$_->{$page_id_field}} @$all]->[0];
    my $non_exist_page_id = $max_page_id + 1;

    my $search_id = $app->$model->public_id(
        {
            $page_id_field => $non_exist_page_id,
            id             => $all->[0]->{id},
        }
    );

    my $must_be_undef = $app->$model->get($search_id);

    ok(!defined($must_be_undef), "model '$model' doesn't ignore page_id when searching by public_id");
}

run_tests(
    sub {
        my ($app) = @_;

        my @block_models = grep {blessed($app->{$_}) and $app->$_->isa('Application::Model::Block')} keys %$app;

        for my $model (@block_models) {
            check_model($app, $model);
        }

        return;
    },
);
