use strict;
use warnings FATAL => 'all';
use utf8;

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;

my $PAGE_ID = 142898;
my $TAG_ID  = 344425;
my $IDS     = [$PAGE_ID, $TAG_ID];

sub check_successful_edit {
    my ($app) = @_;

    change_cur_user($app, 'mocked-yan-partner');

    is(
        $app->block_tags->get(
            {
                page_id => $PAGE_ID,
                tag_id  => $TAG_ID,
            }
          )->{caption},
        '240х400 1-3 дня',
        'got expected caption before change',
      );

    my $data = $app->block_tags->do_action($IDS, 'edit', caption => 'новый caption',);
    is(
        $app->block_tags->get(
            {
                page_id => $PAGE_ID,
                tag_id  => $TAG_ID,
            }
          )->{caption},
        'новый caption',
        'got expected caption after change',
      );

    cmp_deeply(
        $app->partner_db->block_tags_action_log->get_all(),
        [
            {
                action         => 'edit',
                comment        => '',
                dt             => ignore(),
                elem_page_id   => $PAGE_ID,
                elem_tag_id    => $TAG_ID,
                id             => 1,
                new_multistate => 1,
                old_multistate => 1,
                opts           => '{"caption":"новый caption"}',
                user_id        => 1009,
            },
        ],
        'got expected data in block_tags_action_log',
    );
}

sub check_unsuccessful_edit_with_incorrect_data {
    my ($app) = @_;

    change_cur_user($app, 'mocked-yan-partner');

    eval {my $data2 = $app->block_tags->do_action($IDS, 'edit', caption => '',);};

    ok($@, 'do_action( edit ) throws exception on incorrect data');
}

sub check_unsuccessful_edit_no_access {
    my ($app) = @_;

    change_cur_user($app, 'mocked-yan-partner');

    # этот page принадлежит логину mocked-mobile-app-partner
    my $page_id = 43569;
    my $tag_id  = 1;

    my $original_data = $app->partner_db->block_tags->get_all(
        fields => [qw(caption)],
        filter => {
            page_id => $page_id,
            tag_id  => $tag_id,
        }
    );

    cmp_deeply($original_data, [{caption => 'Some name'}], 'got expected caption before change');

    eval {my $data2 = $app->block_tags->do_action([$page_id, $tag_id], 'edit', caption => 123);};
    ok($@, 'do_action( edit ) throws exception if page is not available');

    my $data_after_change = $app->partner_db->block_tags->get_all(
        fields => [qw(caption)],
        filter => {
            page_id => $page_id,
            tag_id  => $tag_id,
        }
    );

    cmp_deeply($original_data, $data_after_change, 'data has not changed',);

}

run_tests(
    sub {
        my ($app) = @_;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        check_successful_edit($app);
        check_unsuccessful_edit_with_incorrect_data($app);
        check_unsuccessful_edit_no_access($app);

    }
);
