use strict;
use warnings FATAL => 'all';
use utf8;

use Test::Partner2::Simple;
use Test::More;

my $PAGE_ID = 142898;
my $TAG_ID  = 344425;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-partner');

        is(
            $app->block_tags->get(
                {
                    page_id => $PAGE_ID,
                    tag_id  => $TAG_ID,
                }
              )->{caption},
            '240х400 1-3 дня',
            'get with HASHREF',
          );

        is(
            $app->block_tags->get(sprintf('%s_%s', $TAG_ID, $PAGE_ID),)->{caption},
            '240х400 1-3 дня',
            'get with public_id',
          );

    },
);
