use strict;
use warnings FATAL => 'all';
use utf8;

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;

sub check_available_block_tags {
    my (%opts) = @_;

    my $app = delete($opts{app});

    change_cur_user($app, $opts{login});

    my $data = $app->block_tags->get_all(fields => [qw(caption page_id tag_id )]);

    cmp_bag($data, $opts{expected}, sprintf('login "%s" get expected data in block_tags->get_all()', $opts{login}),);
}

run_tests(
    sub {
        my ($app) = @_;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        check_available_block_tags(
            app      => $app,
            login    => 'mocked-yan-partner',
            expected => [
                {
                    page_id => 142898,
                    tag_id  => 344425,
                    caption => '240х400 1-3 дня',
                },
                {
                    page_id => 41443,
                    tag_id  => 1,
                    caption => 'Горизонтальный - Блоги - Футер - 4шт.',
                },
                {
                    page_id => 111161,
                    tag_id  => 4,
                    caption => 'Мобильный, низ, 1 об',
                },
            ]
        );

        check_available_block_tags(
            app      => $app,
            login    => 'mocked-video-partner',
            expected => [
                {
                    page_id => 128972,
                    tag_id  => 7,
                    caption => '240х400',
                },
            ]
        );

        check_available_block_tags(
            app      => $app,
            login    => 'mocked-mobile-app-partner',
            expected => [
                {
                    page_id => 43569,
                    tag_id  => 1,
                    caption => 'Some name',
                },
            ]
        );

    },
);
