#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences qw( eq_or_diff );

use qbit;

my $fixture = {
    'browsers only' => {
        conditions => {browsers => ["2", 3, 4, 5, 6, 7, 28, 55, 56, 86, 88],},
        expect     => [
            [
                ['browser-name', 'equal', '2'],
                ['browser-name', 'equal', '3'],
                ['browser-name', 'equal', '4'],
                ['browser-name', 'equal', '5'],
                ['browser-name', 'equal', '6'],
                ['browser-name', 'equal', '7'],
                ['browser-name', 'equal', '28'],
                ['browser-name', 'equal', '55'],
                ['browser-name', 'equal', '56'],
                ['browser-name', 'equal', '86'],
                ['browser-name', 'equal', '88']
            ]
        ],
    },
    'devices only' => {
        conditions => {devices => ['desktop', 'mobile', 'smarttv', 'tablet'],},
        expect     => [
            [
                ['device-is-desktop', 'equal', '1'],
                ['device-is-mobile',  'equal', '1'],
                ['device-is-tv',      'equal', '1'],
                ['device-is-tablet',  'equal', '1']
            ]
        ],
    },
    'headers only' => {
        conditions => {
            'headers' => {
                'accept'       => ['application/json', 'text/plain'],
                'content-type' => ['text/plain']
            },
        },
        expect => [
            [
                ['accept',       'equal', 'application/json'],
                ['accept',       'equal', 'text/plain'],
                ['content-type', 'equal', 'text/plain'],
            ]
        ]
    },
    'query_args only' => {
        conditions => {
            'query_args' => {
                'adb_enables' => ["1"],
                'puid1'       => ['foo', 'bar'],
                'puid63'      => ['baz'],
            },
        },
        expect => [
            [
                ['adb_enables', 'equal', '1'],
                ['puid1',       'match', 'foo'],
                ['puid1',       'match', 'bar'],
                ['puid63',      'match', 'baz'],

            ]
        ]
    },
    'regions only' => {
        conditions => {'regions' => ["1", 2, 3, 5, 8],},
        expect     => [
            [
                ['reg-id', 'equal', '1'],
                ['reg-id', 'equal', '2'],
                ['reg-id', 'equal', '3'],
                ['reg-id', 'equal', '5'],
                ['reg-id', 'equal', '8'],
            ]
        ]
    },
    'systems only' => {
        conditions => {'systems' => ["2", 3, 4, 15, 16, 33],},
        expect     => [
            [
                ['detailed-device-type', 'equal', '2'],
                ['detailed-device-type', 'equal', '3'],
                ['detailed-device-type', 'equal', '4'],
                ['detailed-device-type', 'equal', '15'],
                ['detailed-device-type', 'equal', '16'],
                ['detailed-device-type', 'equal', '33']
            ]
        ]
    },
    'urls only' => {
        conditions => {'urls' => ['http://foo.com', 'https://bar.net', 'https://fooBAR.baZ', 'foo.bar', 'foo=bar']},
        expect     => [
            [
                ['referer', 'like', '%http://foo.com%'],
                ['referer', 'like', '%https://bar.net%'],
                ['referer', 'like', '%https://foobar.baz%'],
                ['referer', 'like', '%foo.bar%'],
                ['referer', 'like', '%foo=bar%']
            ]
        ]
    },
    'complex' => {
        conditions => {
            'browsers' => [2,         88],
            'devices'  => ['desktop', 'smarttv'],
            'headers'  => {
                'accept'       => ['application/json'],
                'content-type' => ['text/plain']
            },
            'query_args' => {
                'puid1'       => ['foo', 'bar'],
                'adb-enabled' => [1]
            },
            'regions' => [1,                255],
            'systems' => [15,               33],
            'urls'    => ['http://foo.com', 'https://bar.net']
        },
        expect => [
            [['browser-name',      'equal', '2'],                ['browser-name', 'equal', '88']],
            [['device-is-desktop', 'equal', '1'],                ['device-is-tv', 'equal', '1']],
            [['accept',            'equal', 'application/json'], ['content-type', 'equal', 'text/plain']],
            [['adb-enabled', 'equal', '1'], ['puid1',  'match', 'foo'], ['puid1', 'match', 'bar']],
            [['reg-id',      'equal', '1'], ['reg-id', 'equal', '255']],
            [['detailed-device-type', 'equal', '15'], ['detailed-device-type', 'equal', '33']],
            [['referer', 'like', '%http://foo.com%'], ['referer', 'like', '%https://bar.net%']],
        ]
    },
    'with_empty_params' => {
        conditions => {
            'query_args' => {},
            'urls'       => ['deposits', 'credits', 'mortgage']
        },
        expect =>
          [[['referer', 'like', '%deposits%'], ['referer', 'like', '%credits%'], ['referer', 'like', '%mortgage%'],]]
    },
};

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test_name (sort keys %$fixture) {
            my ($conditions, $expect) = @{$fixture->{$test_name}}{qw( conditions  expect )};
            my $got = $app->business_rules->get_bk_expression($conditions);

            eq_or_diff($got, $expect, $test_name, {context => 10});
        }
    },
    dont_create_database => TRUE
);
