#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @tests = (
    {
        title => 'ok',
        mock  => sub {
            return [{val => 1}];
        },
    },
    {
        title => 'fail',
        mock  => sub {
            return [{val => 0}];
        },
    },
    {
        title => 'db error',
        mock  => sub {
            throw Exception::DB 'force fail connect to db';
        },
    },
);
run_tests(
    sub {
        my ($app) = @_;

        my $mock;
        mock_subs(
            {
                'QBit::Application::Model::DB::_get_all' => sub {
                    return $mock->();
                },
            }
        );

        my @result;
        for my $test (@tests) {
            $mock = $test->{mock};
            my $answer = $app->check_alive->check_db_alive();
            push @result,
              {
                title  => $test->{title},
                answer => $answer,
              };
        }

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has);
    },
    init => ['check_alive', 'kv_store'],
);
