#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @tests = (
    {
        title => 'ok',
        value => 0,
    },
    {
        title => 'force fail',
        value => 1,
        mocks => {},
    },
    {
        title => 'db error',
        mocks => {
            'Application::Model::CheckAlive::Test::kv_store_key_test' => sub {
                throw Exception::DB 'force fail connect to db';
            },
        },
    },
);
run_tests(
    sub {
        my ($app) = @_;

        my $value;
        mock_subs(
            {
                'QBit::Application::Model::KvStore::get' => sub {
                    return $value;
                },
            }
        );

        my @result;
        for my $test (@tests) {
            $value = $test->{value};
            if ($test->{mocks}) {
                mock_subs($test->{mocks});
            }

            my $answer = $app->check_alive->check_force_fail();
            push @result,
              {
                title  => $test->{title},
                answer => $answer,
              };

            if ($test->{mocks}) {
                restore_subs([keys %{$test->{mocks}}]);
            }
        }

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has);
    },
    init => ['check_alive', 'kv_store'],
);
