#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    sub {
        my ($app) = @_;

        my %kv_store;
        my $count         = 0;
        my %alive_results = (
            ok   => [0, []],
            fail => [1, ['fail']],
        );
        my $alive_result;
        mock_subs(
            {
                'QBit::Application::Model::KvStore::get' => sub {
                    my ($self, $key) = @_;
                    return $kv_store{$key};
                },
                'QBit::Application::Model::KvStore::set' => sub {
                    my ($self, $key, $value) = @_;
                    return $kv_store{$key} = $value;
                },
                'Application::Model::CheckAlive::_is_alive_once' => sub {
                    $count++;
                    return @{$alive_results{$alive_result}};
                },
                'Application::Model::CheckAlive::FirstRun::get_rev_for_workload' => sub {
                    return 1;
                  }
            }
        );

        $alive_result = 'ok';
        my @result;
        my @res = $app->check_alive->_is_alive();
        push @result,
          {
            title  => 'first run - no data',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };
        @res = $app->check_alive->_is_alive();
        push @result,
          {
            title  => 'second run - no data, count incremented',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };

        $ENV{PORTO_NAME} = 'ISS-AGENT--fg6ucvzuqv33v5fu/pod_agent_box_PerlApp/workload_intapi_fcgi_start';
        no warnings 'once';
        $Application::Model::CheckAlive::FirstRun::DATA = undef;

        $alive_result = 'fail';
        @res          = $app->check_alive->_is_alive();
        push @result,
          {
            title  => '3rd run - has data, count incremented',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };
        @res = $app->check_alive->_is_alive();
        push @result,
          {
            title  => '4th run - has data, count incremented',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };
        $alive_result = 'ok';
        @res          = $app->check_alive->_is_alive();
        push @result,
          {
            title  => '5th run - has data, count incremented',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };

        @res = $app->check_alive->_is_alive();
        push @result,
          {
            title  => '6th run - has data, count keep',
            store  => clone(\%kv_store),
            count  => $count,
            result => clone(\@res),
          };

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has);
    },
    init => ['check_alive', 'kv_store'],
);
