#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @tests = (
    {
        title     => 'wo_params',
        params    => [],
        test_data => {
            test1    => undef,
            test2    => undef,
            get_skip => {},
        },
    },
    {
        title     => 'raw',
        params    => [raw => TRUE],
        test_data => {
            test1    => undef,
            test2    => undef,
            get_skip => {},
        },
    },
    {
        title     => 'fail_raw',
        params    => [raw => TRUE],
        test_data => {
            test1    => 'Fail test1',
            test2    => undef,
            get_skip => {},
        },
    },
    {
        title     => 'fail1',
        params    => [],
        test_data => {
            test1    => 'Fail test1',
            test2    => undef,
            get_skip => {},
        },
    },
    {
        title     => 'fail2',
        params    => [],
        test_data => {
            test1    => undef,
            test2    => 'Fail test2',
            get_skip => {},
        },
    },
    {
        title     => 'skip',
        params    => [],
        test_data => {
            test1    => 'Fail test1',
            test2    => undef,
            get_skip => {test1 => {':all' => TRUE}},
        },
    },
);

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'once';
        my %checks = (
            test1 => {
                handler       => 'test1',
                order         => 1,
                stop_on_error => TRUE,
            },
            test2 => {
                handler => 'test2',
                order   => 2,
            },
        );

        my $log;
        my $test_data;
        mock_subs(
            {
                'Application::Model::CheckAlive::INFO' => sub {
                    my ($msg) = @_;
                    push @$log, "INFO: $msg";
                },
                'Application::Model::CheckAlive::ERROR' => sub {
                    my ($msg) = @_;
                    push @$log, "ERROR: $msg";
                },
                'Application::Model::CheckAlive::test1' => sub {
                    return $test_data->{test1};
                },
                'Application::Model::CheckAlive::test2' => sub {
                    return $test_data->{test2};
                },
                'Application::Model::CheckAlive::get_skip' => sub {
                    return $test_data->{get_skip};
                },
                'Application::Model::CheckAlive::get_first_run_result' => sub {
                    return undef;
                },
                'Application::Model::CheckAlive::set_first_run_result' => sub {
                },
            }
        );

        my @result;
        for my $test (@tests) {
            $log       = [];
            $test_data = $test->{test_data};

            my $answer = get_answer($app->check_alive->is_alive(checks => \%checks, @{$test->{params}}));

            push @result,
              {
                title  => $test->{title},
                answer => $answer,
                log    => $log
              };
        }

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has);
    },
    init => ['check_alive'],
);

sub get_answer {
    my ($r, $m) = @_;

    my $out = '';
    if (ref $r eq 'CODE') {
        while (1) {
            my $t = $r->();
            last unless $t && @$t;
            $out .= join('', @$t);
        }
    } else {
        $out = $r || $m;
    }

    return $out;
}
