#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    \&main_test,
    init  => ['check_alive'],
    mocks => {mock_juggler => FALSE},
);

sub main_test {
    my ($app) = @_;

    my $send;
    mock_subs(
        {
            'Partner2::Juggler::API::send' => sub {
                my ($self, %opts) = @_;
                $send = clone(\%opts);
            },
        }
    );

    $ENV{PORTO_NAME} = 'ISS-AGENT--fg6ucvzuqv33v5fu/pod_agent_box_PerlApp/workload_intapi_fcgi_start';
    $app->set_option('hostname', 'iss.dev-partner2.sas.yp-c.yandex.net');

    $app->check_alive->send_to_juggler(1, ['error']);

    my $has = get_test_data_and_update_if_needed('data.json', $send);
    eq_or_diff($send, $has);
}
