#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @tests = (
    {
        title => 'ok',
        value => 0,
    },
    {
        title => 'force fail',
        value => 'fail connect',
    },
);

prepare_app();
run_tests(
    sub {
        my ($app) = @_;

        my $value;
        mock_subs(
            {
                'Application::Model::CheckAlive::_check_connect' => sub {
                    return $value;
                },
            }
        );

        my @result;
        for my $test (@tests) {
            $value = $test->{value};
            my $answer = $app->check_alive->check_net_alive();
            push @result,
              {
                title  => $test->{title},
                answer => $answer,
              };
        }

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has);
    },
    init                => ['check_alive'],
    application_package => 'WebInterface',

);

sub prepare_app {
    require WebInterface;
    mock_subs(
        {
            'WebInterface::pre_run' => sub {
                my ($self) = @_;
                $self->Application::pre_run();
            },
        }
    );
}
