#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my @tests = (
    {
        title  => 'ok',
        ticket => 'tvm_ticket',
    },
    {
        title  => 'fail tvm_ticket',
        ticket => undef,
    },
);

sub main_test {
    my ($app) = @_;

    my %mocks;
    my $test_data;
    for my $tvm (@{$app->check_alive->_get_tvm_aliases_from_config()}) {
        my $model = $tvm->{model};
        my $ref   = ref $app->$model;
        if ($app->$model->can('check_tvm_service')) {
            $mocks{$ref . '::check_tvm_service'} = sub {
                return $test_data->{$model};
              }
        }
    }

    mock_subs(
        {
            'Application::Model::API::Yandex::TVM::get_service_ticket' => sub {
                return $test_data->{ticket};
            },
            %mocks,
        }
    );

    my @result;
    for my $test (@tests) {
        $test_data = $test;

        my $answer = $app->check_alive->check_tvm_alive();

        push @result,
          {
            title  => $test->{title},
            answer => $answer,
          };
    }

    my $has = get_test_data_and_update_if_needed('data.json', \@result);
    eq_or_diff(\@result, $has);
}

sub prepare_app {
    require WebInterface;
    mock_subs(
        {
            'WebInterface::pre_run' => sub {
                my ($self) = @_;
                $self->Application::pre_run();
            },
        }
    );
}

prepare_app();
run_tests(
    \&main_test,
    init                => ['check_alive', 'api_tvm'],
    application_package => 'WebInterface',
);
