#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::Differences;
use Test::More tests => 7;

my $mocked_pi_user = {
    login     => 'mocked-yan-partner-wo',
    id        => 1034,
    client_id => 11034,
};

my $mocked_pi_user_contracts = {
    adfox_contract => {
        Client      => {},
        Collaterals => {},
        Contract    => {
            contract2_id => 13579,
            external_id  => 'external adfox contract',
        },
        Person => {},
    },
    pi_contract => {
        Client      => {},
        Collaterals => {},
        Contract    => {
            contract2_id => 24680,
            external_id  => 'external PI contract',
        },
        Person => {},
    },
};

my $mocked_adfox_user = {
    adfox_login         => 'adfox_login_2',
    adfox_password      => undef,
    allow_paid_services => 1,
    from_offer          => 1,
};

my $created_offer_contract = {
    ID          => $mocked_pi_user_contracts->{pi_contract}->{Contract}->{contract2_id},
    EXTERNAL_ID => $mocked_pi_user_contracts->{pi_contract}->{Contract}->{external_id},
};
my $created_adfox_contract = {
    'client_id'   => $mocked_pi_user->{client_id},
    'contract_id' => '1236739'
};

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';
        *{'Application::Model::Users::check_pi_adfox_contracts'} = sub {
            my ($self, %opts) = @_;

            is_deeply(
                \%opts,
                {
                    %$mocked_adfox_user,
                    (
                        from_offer => TRUE,
                        user_id    => $mocked_pi_user->{id},
                    ),
                },
                'Users::check_pi_adfox_contracts; correct parameters'
            );

            return $mocked_pi_user_contracts;
        };
        *{'Application::Model::Users::accept_common_offer'} = sub {
            my ($self, %opts) = @_;

            is_deeply(
                \%opts,
                {
                    adfox_login => $mocked_adfox_user->{adfox_login},
                    client_id   => $mocked_pi_user->{client_id},
                    contracts   => $mocked_pi_user_contracts,
                    from_offer  => TRUE,
                    user_id     => $mocked_pi_user->{id},

                },
                'Users::accept_common_offer; correct parameters'
            );

            return $created_offer_contract;
        };
        *{'Application::Model::CommonOffer::after_offer_accept'} = sub {
            #$pi_client_id, $contracts, $result, $adfox_offer
            is_deeply(
                [@_[1 .. $#_]],
                [$mocked_pi_user->{client_id}, $mocked_pi_user_contracts, $created_offer_contract, 1],
                'CommonOffer::after_offer_accept; correct parameters'
            );
        };
        *{'Application::Model::Documents::get_active_contract'} = sub {
            return {
                Contract => $mocked_pi_user_contracts->{pi_contract}->{Contract},
                Person   => {
                    client_id => $mocked_pi_user->{client_id},
                    id        => 111,
                },
            };
        };

        *{'Application::Model::Users::create_contract_adfox_paid_products'} = sub {
            my ($self, %opts) = @_;

            is_deeply(
                \%opts,
                {
                    'adfox_login' => $mocked_adfox_user->{adfox_login},
                    'mail_info'   => {
                        adfox_contract => $mocked_pi_user_contracts->{adfox_contract},
                        adfox_info     => {
                            id    => '',
                            login => $mocked_adfox_user->{adfox_login},
                        },
                        client_id => $mocked_pi_user->{client_id},
                        contract  => $mocked_pi_user_contracts->{pi_contract}{Contract},
                        login     => $mocked_pi_user->{login},
                        user_id   => $mocked_pi_user->{id},
                    },
                    'user_id' => $mocked_pi_user->{id},
                },
                'Users::create_contract_adfox_paid_products; correct parameters'
            );

            return {
                client_id => $created_adfox_contract->{client_id},
                id        => $created_adfox_contract->{contract_id},
            };
        };

        *{'Application::Model::API::Yandex::AdFoxGraphQL::bind_user'} = sub {
            my ($self, %opts) = @_;

            is_deeply(
                \%opts,
                {
                    'adfox_login'  => $mocked_adfox_user->{adfox_login},
                    'billing_data' => $created_adfox_contract,
                    'presets'      => ['ADFOXSITES', 'MOBILEMEDIATION', 'PAIDPRODUCTS'],
                    'user_id'      => $mocked_pi_user->{id}
                },
                'AdFoxGraphQL::bind_user; correct parameters'
            );

            return {
                id    => 111666,
                login => $mocked_adfox_user->{adfox_login},
            };
        };

        $app->common_offer->offer_accept(
            adfox_login => $mocked_adfox_user->{adfox_login},
            adfox_offer => $mocked_adfox_user->{allow_paid_services}
        );

    },
    init => [qw(common_offer users documents api_adfox_graphql)],
    user => $mocked_pi_user->{login},
);
