#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use Test::MockObject::Extends;

use qbit;

my $PAGE_ID = 12345;

my $TAG1_ID = 1;
my $TAG1    = 'testtag';

my $TAG2_ID = 2;
my $TAG2    = 'testtag2';

run_tests(
    sub {
        my ($app) = @_;

        is($app->cookie_match->get($TAG1_ID, fields => ['tag'])->{'tag'}, $TAG1, 'Check tag');

        $app->cookie_match_link_pi->add(tag_id => $TAG1_ID, tag => $TAG1, page_id => $PAGE_ID);

        cmp_deeply(
            $app->cookie_match_link_pi->get(
                {tag_id => $TAG1_ID, page_id => $PAGE_ID},
                fields => [qw(tag_id page_id tag)]
            ),
            {tag_id => $TAG1_ID, page_id => $PAGE_ID, tag => $TAG1},
            'Check link'
        );

        $app->cookie_match_link_pi->add(tag_id => $TAG2_ID, tag => $TAG2, page_id => $PAGE_ID);

        cmp_deeply(
            $app->cookie_match_link_pi->get_all(fields => [qw(tag_id page_id tag)], filter => {page_id => $PAGE_ID}),
            [{tag_id => $TAG2_ID, page_id => $PAGE_ID, tag => $TAG2}],
            'Check link 2'
        );
    },
    user => 'mocked-yan-manager',
);
