#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use Test::MockObject::Extends;

use qbit;

my $PK = {tag_id => 1, page_id => 54321};

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            $app->cookie_match_link_pi->get($PK, fields => [qw(tag_id page_id tag)]),
            {%$PK, tag => 'testtag'},
            'Check link'
        );

        $app->cookie_match_link_pi->delete($PK);

        is($app->cookie_match_link_pi->get($PK, fields => [qw(tag_id page_id tag)]), undef, 'Check delete');
    },
    user => 'mocked-yan-manager',
);
