use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::More;
use Test::Differences;
use Test::Partner::Utils;

my $new_page_id = 31415;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);

        no strict 'refs';
        no warnings 'redefine';
        local *{'QBit::Application::Model::API::Yandex::HTTPGoZora::is_site_working'} = sub {
            return 1;
        };
        local *{'Application::Model::API::Yandex::UtilsPartner2::get_next_page_id'} = sub {
            return $new_page_id;
        };

        change_cur_user($app, 'mocked-yan-partner');

        my $site_id = $app->site->add(get_new_site());

        $app->context_on_site_campaign->add(
            caption   => 'caption',
            domain_id => $site_id,
        );

        my @page_ids = $app->cur_user->get_all_page_ids_available_for_cur_user();

        eq_or_diff(
            \@page_ids,
            [1, 799, 800, 803, 4143, $new_page_id, 41443, 111161, 142898],
            'got expected list of Page IDs'
        );
    },
    init => [qw(api_utils_partner2 api_http_gozora)],
);
