use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More tests => 3;
use Test::Differences;

run_tests(
    sub {
        my ($app) = @_;

        my $pages =
          $app->cur_user->get_all_page_ids_owned_by_user_for_global_concurents($app->cur_user->get_cur_user_id());
        eq_or_diff(
            [sort {$a->{id} <=> $b->{id}} @$pages],
            [
                {
                    'id'      => '799',
                    'model'   => 'context_on_site_campaign',
                    'page_id' => '799'
                },
                {
                    'id'      => '41443',
                    'model'   => 'context_on_site_campaign',
                    'page_id' => '41443'
                },
            ]
        );

    },
    user => 'mocked-yan-partner',
);
