use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils;

my @logins = qw(
  mocked-yan-partner
  mocked-yan-partner-assessor
  );

run_tests(
    sub {
        my ($app) = @_;

        for my $login (@logins) {
            change_cur_user($app, $login);
            my $out = $app->get_option('cur_user', {});
            my $expected = get_test_data_and_update_if_needed("$login.json", $out);
            eq_or_diff(from_json(to_json($out)), $expected, 'check content');
        }

    },
);
