#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences;

use File::Basename;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $file_path = $app->db_dumper->dump(page_ids => [142898], filename_part => 'test');

        my $dump = readfile($file_path);

        unlink($file_path);

        my $dirname = dirname(__FILE__);

        if (need_self_update()) {
            writefile($dirname . "/db.dump", $dump);
        }

        eq_or_diff($dump, readfile($dirname . "/db.dump"), 'check dump');
    },
);
