use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Deep qw/cmp_deeply/;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);
        mock_bk($app);
        mock_balance($app);

        $app->api_balance->mock('link_dsp_to_client', sub {return 1;});
        $app->api_http_bk->mock(add_or_get_if_exists_dsp => sub {shift; local_add_or_get_if_exists_dsp(0, @_)});

        my %dsp = (
            login          => 'mocked-dsp-partner',
            short_caption  => 'sample dsp',
            display_name   => 'sample dsp',
            url            => 'http://ya.ru',
            types          => [1],
            postmoderated  => 'asdfo',
            is_ssp_allowed => 0,
        );

        my %for_approve = (
            tag           => 'yamarket',
            url           => 'http://ya.ru',
            short_caption => 'sample dsp',
        );

        my $dsp_id = $app->dsp->add(%dsp);

        $app->dsp->do_action($dsp_id, 'approve', %for_approve);

        cmp_deeply(
            $app->dsp->_get_data_for_bk($dsp_id),
            {
                disabled                => 1,
                display_name            => 'sample dsp',
                dsp_types               => [1],
                formats                 => [],
                id                      => $dsp_id,
                patch                   => undef,
                postmoderated           => 0,
                short_caption           => 'sample dsp',
                show_probability        => 100,
                skipnoud                => 0,
                tag                     => 'yamarket',
                unmoderated_rtb_auction => 0,
                url                     => 'http://ya.ru',
                use_pnocsy              => 0,
                is_ssp_allowed          => 0,
                works_on_all_platforms  => 0
            },
            "check _get_data_for_bk for dsp_id $dsp_id"
        );

        $app->dsp->do_action($dsp_id, 'edit', is_ssp_allowed => 1);

        cmp_deeply(
            $app->dsp->_get_data_for_bk($dsp_id),
            {
                disabled                => 1,
                display_name            => 'sample dsp',
                dsp_types               => [1],
                formats                 => [],
                id                      => $dsp_id,
                patch                   => undef,
                postmoderated           => 0,
                short_caption           => 'sample dsp',
                show_probability        => 100,
                skipnoud                => 0,
                tag                     => 'yamarket',
                unmoderated_rtb_auction => 0,
                url                     => 'http://ya.ru',
                use_pnocsy              => 0,
                is_ssp_allowed          => 1,
                works_on_all_platforms  => 0
            },
            "check _get_data_for_bk for dsp_id $dsp_id after edit is_ssp_allowed -> 1"
        );

        $app->dsp->do_action($dsp_id, 'create_in_bk');
        $app->dsp->do_action($dsp_id, 'link_in_balance');
        $app->dsp->do_action($dsp_id, 'start_on_all_platforms');

        cmp_deeply(
            $app->dsp->_get_data_for_bk($dsp_id),
            {
                disabled                => 1,
                display_name            => 'sample dsp',
                dsp_types               => [1],
                formats                 => [],
                id                      => $dsp_id,
                patch                   => undef,
                postmoderated           => 0,
                short_caption           => 'sample dsp',
                show_probability        => 100,
                skipnoud                => 0,
                tag                     => 'yamarket',
                unmoderated_rtb_auction => 0,
                url                     => 'http://ya.ru',
                use_pnocsy              => 0,
                is_ssp_allowed          => 1,
                works_on_all_platforms  => 1
            },
            "check _get_data_for_bk for dsp_id $dsp_id after do action working_on_all_platforms"
        );
    },
);

sub local_add_or_get_if_exists_dsp {
    my ($value, %dsp) = @_;

    is($dsp{use_pnocsy}, $value, "use_pnocsy is $value");
    return {data_key => 'datakeyfrombk'};
}
