#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use PiConstants qw(
  $DSP_MEDIA_TYPE_ID
  $DSP_MOBILE_TYPE_ID
  $DSP_BANNER_FORMAT_ID
  $DSP_NATIVE_FORMAT_ID
  $DSP_VIDEO_FORMAT_ID
  );

use Test::Partner2::Simple;
use Test::Partner2::Fixture;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils;
use Test::Partner2::Mock;

use qbit;

# my @dsp_fixtures = ('dsp_direct', 'dsp_mobile_banner', 'dsp_mobile_native', 'dsp_media', 'dsp_video',);

my @dsp_fixtures = (
    'dsp_direct',                       'dsp_awaps_mobile',
    'dsp_video_interstitial_mobile_10', 'dsp_video_interstitial_mobile_7',
    'dsp_video_interstitial_mobile_12', 'dsp_media',
    'dsp_video',                        'dsp_mobile',
    'dsp_media_video_mobile',           'dsp_media_video_mobile_with_internal_tag',
    'dsp_nonmoder',                     'dsp_mobile_native',
    'dsp_mobile_banner',
);

my @dsp_fixtures_extra = ('dsp_video_interstitial_mobile_10');

my @methods            = (qw(get_available_dsps get_default_dsps));
my @mobile_block_types = (qw(banner interstitial native adaptive_banner rewarded));

my @block_fixtures = (
    'partner_mobile_native_rtb_block',                       'partner_mobile_banner_rtb_block',
    'partner_mobile_interstitial_rtb_block',                 'partner_mobile_rewarded_rtb_block',
    'partner_mobile_adaptive_banner_rtb_block',              'partner_instream_video_block',
    'partner_mobile_banner_rtb_block_with_show_video',       'partner_mobile_native_rtb_block_with_show_video_true',
    'partner_mobile_interstitial_rtb_block_with_show_video', 'partner_mobile_native_rtb_block_with_show_video_true',
);

my %block_name_by_id;

run_tests(
    sub {
        my ($app) = @_;
        mock_bk($app);

        use_common_blocks_table($app);

        my $dsps = get_fixtures_hash(@dsp_fixtures);
        my %dsps_r = map {$dsps->{$_}{id} => $_} keys %$dsps;

        $app->set_cur_user(get_fixture('mocked_dsp_manager'));

        for my $block_name (@block_fixtures) {
            my $block_id = get_normalized_block_id(get_fixture($block_name));
            $block_name_by_id{$block_id->{page_id}}{$block_id->{id}} = $block_name;
        }

        my $got_data = {};

        $app->dsp->do_action($dsps->{dsp_direct}->{id}, 'stop_on_all_platforms');

        for my $dsp_name (sort {$dsps->{$a}{id} <=> $dsps->{$b}{id}} keys %$dsps) {
            my $dsp = $dsps->{$dsp_name};
            $got_data->{links}{$dsp_name}{before} = [sort @{get_all_dsp_links($app, $dsp)}];
            $app->dsp->do_action($dsp->{id}, 'start_on_all_platforms');
            $got_data->{links}{$dsp_name}{after} = [sort @{get_all_dsp_links($app, $dsp)}];
        }

        for my $block_type (@mobile_block_types) {
            for my $method (@methods) {
                for my $video (0 .. 1) {
                    $got_data->{lists}{$block_type}{"show_video = $video"}{$method} =
                      [sort map {$dsps_r{$_->{id}} // $_->{id}}
                          @{$app->mobile_app_rtb->$method({block_type => $block_type, show_video => $video})}];
                }
            }
        }

        my $dsp_media = $dsps->{dsp_media};
        $app->dsp->do_action(
            $dsp_media->{id}, 'edit',
            types   => [$DSP_MEDIA_TYPE_ID, $DSP_MOBILE_TYPE_ID],
            formats => [$DSP_BANNER_FORMAT_ID]
        );
        $got_data->{action}{start_banner}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'start_on_mobile_block_banner');
        $got_data->{action}{start_banner}{links} = [sort @{get_all_dsp_links($app, $dsp_media)}];

        $app->dsp->do_action($dsp_media->{id}, 'edit', formats => [$DSP_NATIVE_FORMAT_ID]);
        $got_data->{action}{stop_banner}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'stop_on_mobile_block_banner');
        $got_data->{action}{stop_banner}{links} = [sort @{get_all_dsp_links($app, $dsp_media)}];

        $got_data->{action}{start_native}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'start_on_mobile_block_native');
        $got_data->{action}{start_native}{links} = [sort @{get_all_dsp_links($app, $dsp_media)}];

        $app->dsp->do_action($dsp_media->{id}, 'edit', formats => [$DSP_BANNER_FORMAT_ID, $DSP_VIDEO_FORMAT_ID]);
        $got_data->{action}{two_format}{start_banner}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'start_on_mobile_block_banner');
        $got_data->{action}{two_format}{start_video}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'start_on_mobile_block_video');
        $got_data->{action}{two_format}{stop_native}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'stop_on_mobile_block_native');
        $got_data->{action}{two_format}{both}{links} = [sort @{get_all_dsp_links($app, $dsp_media)}];

        $app->dsp->do_action($dsp_media->{id}, 'edit', formats => [$DSP_BANNER_FORMAT_ID]);
        $got_data->{action}{two_format}{stop_video}{result} =
          $app->dsp->maybe_do_action($dsp_media->{id}, 'stop_on_mobile_block_video');
        $got_data->{action}{two_format}{banner}{links} = [sort @{get_all_dsp_links($app, $dsp_media)}];

        my $expected_data = get_test_data_and_update_if_needed('data.json', $got_data);
        eq_or_diff(from_json(to_json($got_data)), $expected_data, 'check content');
    },
    fill_databases => 0,
    fixtures       => [@block_fixtures, @dsp_fixtures],
);

sub get_all_dsp_links {
    my ($app, $dsp) = @_;

    my @links = map {
        my $id = get_normalized_block_id($_);
        $block_name_by_id{$id->{page_id}}{$id->{id}}
      } @{
        $app->partner_db->block_dsps->get_all(
            fields => [qw(page_id block_id dsp_id)],
            filter => [dsp_id => '=' => \$dsp->{id}]
        )
      };
    return \@links;
}

sub get_normalized_block_id {
    my ($block) = @_;

    my $id = {};
    for my $possible_page_id_name (qw(page_id campaign_id context_page_id)) {
        $id->{page_id} = $block->{$possible_page_id_name} if exists($block->{$possible_page_id_name});
    }

    for my $possible_block_id_name (qw(block_id id)) {
        $id->{id} = $block->{$possible_block_id_name} if exists($block->{$possible_block_id_name});
    }

    return $id;
}
