use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);

        my $dsp_id = $app->dsp->add(
            login         => 'mocked-dsp-partner',
            short_caption => 'sample dsp',
            display_name  => 'sample dsp',
            url           => 'http://ya.ru',
            types         => [],
            postmoderated => 'asdf',
        );

        my $result = $app->dsp->do_action(
            $dsp_id,
            'approve',

            # В mocked_databases уже есть dsp с таким тегом, но с другим url
            tag => 'sociomantic',

            # При выполнении экшена 'approve' нужно передавать поля, иначе они затруться
            url           => 'http://ya.ru',
            short_caption => 'sample dsp',
        );

        my $dsp = $app->dsp->get($dsp_id, fields => [qw( short_caption tag url )]);

        cmp_deeply(
            $dsp,
            {
                short_caption => 'sample dsp',
                url           => 'http://ya.ru',
                tag           => 'sociomantic',
            },
        );

    },
);
