use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Deep qw/cmp_deeply/;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);
        mock_bk($app);

        my %dsp = (
            login         => 'mocked-dsp-partner',
            short_caption => 'sample dsp',
            display_name  => 'sample dsp',
            url           => 'http://ya.ru',
            types         => [],
            postmoderated => 'asdf',
        );

        my %for_approve = (
            tag           => 'yamarket',
            url           => 'http://ya.ru',
            short_caption => 'sample dsp',
        );

        # check if tag is yamarket
        $app->api_http_bk->mock(add_or_get_if_exists_dsp => sub {shift; local_add_or_get_if_exists_dsp(0, @_)});
        my $dsp_id = $app->dsp->add(%dsp);

        $app->dsp->do_action($dsp_id, 'approve', %for_approve);

        cmp_deeply(
            $app->dsp->_get_data_for_bk($dsp_id),
            {
                disabled                => 1,
                display_name            => 'sample dsp',
                dsp_types               => [],
                formats                 => [],
                id                      => $dsp_id,
                patch                   => undef,
                postmoderated           => 0,
                short_caption           => 'sample dsp',
                show_probability        => 100,
                skipnoud                => 0,
                tag                     => 'yamarket',
                unmoderated_rtb_auction => 0,
                url                     => 'http://ya.ru',
                use_pnocsy              => 0,
                is_ssp_allowed          => 0,
                works_on_all_platforms  => 0,
            },
            "check _get_data_for_bk for dsp_id $dsp_id"
        );

        $app->dsp->on_action_create_in_bk($dsp_id);

        # check another tag
        $app->api_http_bk->mock(add_or_get_if_exists_dsp => sub {shift; local_add_or_get_if_exists_dsp(1, @_)});

        $for_approve{tag} = 'another';
        my $dsp_2_id = $app->dsp->add(%dsp);
        $app->dsp->do_action($dsp_2_id, 'approve', %for_approve);

        cmp_deeply(
            $app->dsp->_get_data_for_bk($dsp_2_id),
            {
                disabled                => 1,
                display_name            => 'sample dsp',
                dsp_types               => [],
                formats                 => [],
                id                      => $dsp_2_id,
                patch                   => undef,
                postmoderated           => 0,
                short_caption           => 'sample dsp',
                show_probability        => 100,
                skipnoud                => 0,
                tag                     => 'another',
                unmoderated_rtb_auction => 0,
                url                     => 'http://ya.ru',
                use_pnocsy              => 1,
                is_ssp_allowed          => 0,
                works_on_all_platforms  => 0,
            },
            "check _get_data_for_bk for dsp_id $dsp_2_id"
        );

        $app->dsp->on_action_create_in_bk($dsp_2_id);
    },
);

sub local_add_or_get_if_exists_dsp {
    my ($value, %dsp) = @_;

    is($dsp{use_pnocsy}, $value, "use_pnocsy is $value");
    return {data_key => 'datakeyfrombk'};
}
