use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        my $dsp_id = 2563149;

        $app->api_http_bk->mock(
            dsp_lb => sub {
                is_deeply(
                    $_[1],
                    {
                        'display_name'            => 'dsp',
                        'disabled'                => 1,
                        'dsp_types'               => ['0'],
                        'formats'                 => [],
                        'id'                      => '2563149',
                        'patch'                   => undef,
                        'postmoderated'           => 0,
                        'short_caption'           => 'AWAPS PMP',
                        'show_probability'        => '100',
                        'skipnoud'                => 0,
                        'tag'                     => 'awaps',
                        'unmoderated_rtb_auction' => 0,
                        'url'            => 'http://awaps.yandex.ru/11/1/0?r_host_id=2&charset=utf-8&rtb_as_ssi=1',
                        'use_pnocsy'     => 0,
                        'is_ssp_allowed' => 1,
                        'works_on_all_platforms' => 0,
                    }
                );
            }
        );

        $app->dsp->do_action($dsp_id, 'stop',);

        $app->api_http_bk->mock(
            dsp_lb => sub {
                is_deeply(
                    $_[1],
                    {
                        'display_name'            => 'dsp',
                        'disabled'                => 0,
                        'dsp_types'               => ['0'],
                        'formats'                 => [],
                        'id'                      => '2563149',
                        'patch'                   => undef,
                        'postmoderated'           => 0,
                        'short_caption'           => 'AWAPS PMP',
                        'show_probability'        => '100',
                        'skipnoud'                => 0,
                        'tag'                     => 'awaps',
                        'unmoderated_rtb_auction' => 0,
                        'url'            => 'http://awaps.yandex.ru/11/1/0?r_host_id=2&charset=utf-8&rtb_as_ssi=1',
                        'use_pnocsy'     => 0,
                        'is_ssp_allowed' => 1,
                        'works_on_all_platforms' => 0,
                    }
                );
            }
        );
        $app->dsp->do_action($dsp_id, 'start',);

    },
    init  => [qw(api_http_bk)],
    mocks => [qw(mock_bk)],
);
