#!/usr/bin/perl

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::More;

use qbit;

my $test_data = [
    {
        model                  => 'video_an_site',
        block_dsps_accessor    => 'block_dsps',
        blocks_accessors       => [qw(video_an_site_inpage video_an_site_instream video_an_site_fullscreen)],
        turned_on_dsp_id       => 2563117,
        blocks_with_turned_dsp => ['154689-1', '154689-2', '154689-3', '128972-1', '128972-2', '128972-3', '128972-4'],
        blocks_with_not_turned_dsp => ['154689-4'],
    },
    {
        model                      => 'context_on_site_campaign',
        block_dsps_accessor        => 'block_dsps',
        blocks_accessors           => [qw(context_on_site_rtb)],
        turned_on_dsp_id           => 2317563,
        blocks_with_turned_dsp     => ['41443-1', '41443-100000', '142898-1'],
        blocks_with_not_turned_dsp => ['88848-1', '88848-2', '43569-1', '153980-2'],
    },
    {
        model                      => 'mobile_app_settings',
        block_dsps_accessor        => 'block_dsps',
        blocks_accessors           => [qw(mobile_app_rtb)],
        turned_on_dsp_id           => undef,
        blocks_with_turned_dsp     => ['43569-1', '153980-2'],
        blocks_with_not_turned_dsp => [],
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);

        my $mobile_dsp = $app->dsp->add(
            postmoderated => 0,
            url           => 'ya.ru',
            short_caption => 'test',
            display_name  => 'test',
            login         => 'mocked-dsp-partner',
            types         => [2],
            formats       => [1],
        );
        $app->partner_db->dsp->edit(
            $mobile_dsp,
            {
                tag        => 'test',
                multistate => (
                    $app->dsp->get_multistates_by_filter(
'created_in_bk and (created_in_pi or not_need_create_in_pi) and linked_in_balance and not deleted'
                      )->[0]
                )
            }
        );

        foreach my $test_case (@$test_data) {
            if ($test_case->{model} eq 'mobile_app_settings') {$test_case->{turned_on_dsp_id} = $mobile_dsp;}

            my $dsp = $app->dsp->get_all(
                fields => ['id', 'short_caption', 'types', 'tag'],
                filter => ['id', '=',             $test_case->{turned_on_dsp_id}]
            );
            my $tmp_rights = $app->add_tmp_rights(
                qw(video_an_site_view_all mobile_app_settings_view_all context_on_site_campaign_view_all users_view_all)
            );
            my $dsps_accessor = $test_case->{block_dsps_accessor};

            $app->dsp->on_action_start_on_all_platforms($dsp->[0]);

            foreach my $block_type (@{$test_case->{blocks_accessors}}) {
                my $page_id_name = $app->$block_type->get_page_id_field_name;
                my $obj = $app->$block_type->get_all(fields => ['id', $page_id_name]);

                foreach my $block (@{$obj}) {
                    my $block_id   = $block->{id};
                    my $page_id    = $block->{$page_id_name};
                    my $page_block = $page_id . "-" . $block_id;

                    ok(
                        in_array($page_block, $test_case->{blocks_with_turned_dsp})
                          || in_array($page_block, $test_case->{blocks_with_not_turned_dsp}),
                        'Block_id in defined list'
                      );

                    if (in_array($page_block, $test_case->{blocks_with_turned_dsp})) {
                        my $dsp_list = $app->partner_db->$dsps_accessor->get_all(
                            filter => ['AND', [['block_id', '=', \$block_id], ['page_id', '=', \$page_id]]]);
                        my @dsps = map {$_->{'dsp_id'}} @$dsp_list;

                        ok(in_array($dsp->[0]->{id}, \@dsps), "DSP is turned on.");
                    } else {
                        my $dsp_list = $app->partner_db->$dsps_accessor->get_all(
                            filter => [
                                'AND',
                                [
                                    ['block_id', '=', \$block_id],
                                    ['page_id',  '=', \$page_id],
                                    ['dsp_id',   '=', \$test_case->{turned_on_dsp_id}]
                                ]
                            ]
                        );
                        my @dsps = map {$_->{'dsp_id'}} @$dsp_list;

                        ok(!@dsps, "DSP is not turned on.");

                    }
                }
            }
        }
    },
);
