use qbit;

use Test::Partner2::Simple;
use Test::More;
require Application::Model::Documents;

my @tests = (
    {
        name   => 'one in hash',
        hash   => {a => 2, b => 3},
        result => 1,
        filter => {a => 2},
    },
    {
        name   => 'two in hash',
        hash   => {a => 2, b => 3, c => 4},
        result => 1,
        filter => {a => 2, b => 3},
    },
    {
        name   => 'two in hash fail',
        hash   => {a => 2, b => 3, c => 4},
        result => '',
        filter => {a => 2, b => 4},
    },
    {
        name   => 'two in hash-hash',
        hash   => {a => 2, b => 3, c => {d => 5}},
        result => 1,
        filter => {a => 2, c => {d => 5}},
    },
    {
        name   => 'two in hash-hash fail 1',
        hash   => {a => 2, b => 3, c => {d => 5}},
        result => '',
        filter => {a => 3, c => {d => 5}},
    },
    {
        name   => 'two in hash-hash fail 2',
        hash   => {a => 2, b => 3, c => {d => 5}},
        result => '',
        filter => {a => 2, c => {d => 6}},
    },
    {
        name   => 'two in hash-hash-hash',
        hash   => {a => {b => {c => {d => 2}}}, e => 3},
        result => 1,
        filter => {a => {b => {c => {d => 2}}}},
    },
    {
        name   => 'two in hash-hash-hash fail',
        hash   => {a => {b => {c => {d => 2}}}, e => 3},
        result => '',
        filter => {a => 2},
    },
);

run_tests(\&main_test, dont_create_database => TRUE,);

sub main_test {
    my ($app) = @_;
    for my $test (@tests) {
        is(Application::Model::Documents::_filter_cmp_hash($test->{hash}, $test->{filter}),
            $test->{result}, $test->{name});
    }
}
