use qbit;

use Test::Partner2::Simple;
use Test::More;
use Test::Differences;

my $fake_client_id = 1234;
my $fake_login     = 'FAKE_LOGIN';

my $fake_contracts = [
    [
        {
            'Person'      => {},
            'Client'      => {},
            'Collaterals' => [],
            'Contract'    => {
                'is_faxed'      => '',
                'is_signed'     => '2016-06-03',
                'dt'            => '2016-06-01',
                'end_dt'        => '',
                'type'          => 'PARTNERS',
                'contract_type' => '9',
                'pay_to'        => '1',
                'reward_type'   => '1',
                'currency'      => '643',
                'external_id'   => 'FAKE_EXTERNAL_ID',
                'vat'           => undef,
                'test_mode'     => 1,
                'person_id'     => '',
                'firm'          => '1',
            }
        },
    ],
    [
        {
            'Person'      => {},
            'Client'      => {},
            'Collaterals' => [],
            'Contract'    => {
                'is_faxed'      => '',
                'is_signed'     => '2016-06-03',
                'dt'            => '2016-06-01',
                'end_dt'        => '',
                'type'          => 'PARTNERS',
                'contract_type' => '9',
                'pay_to'        => '1',
                'reward_type'   => '1',
                'currency'      => '643',
                'external_id'   => 'FAKE_EXTERNAL_ID',
                'vat'           => undef,
                'test_mode'     => 0,
                'person_id'     => '',
                'firm'          => '1',
            }
        }
    ],
];

my $expected_active_for_partner = [
    {
        'Person'   => {},
        'Contract' => {
            'allows_to_fill_part2' => 1,
            'is_faxed'             => '',
            'vat'                  => undef,
            'dt'                   => '2016-06-01',
            'status'               => 'Offer test mode',
            'currency'             => '643',
            'external_id'          => 'FAKE_EXTERNAL_ID',
            'is_signed'            => '2016-06-03',
            'pay_to'               => 1,
            'is_oferta2'           => 1,
            'firm'                 => 1,
            'person_id'            => '',
            'test_mode'            => 1,
            contract_type          => 9,
        }
    },
    {
        'Person'   => {},
        'Contract' => {
            'is_faxed'    => '',
            'vat'         => undef,
            'dt'          => '2016-06-01',
            'status'      => 'Offer accepted',
            'currency'    => '643',
            'external_id' => 'FAKE_EXTERNAL_ID',
            'is_signed'   => '2016-06-03',
            'pay_to'      => 1,
            'is_oferta2'  => 1,
            'firm'        => 1,
            'person_id'   => '',
            'test_mode'   => 0,
            contract_type => 9,
        }
    },
];

run_tests(
    sub {
        my ($app) = @_;

        my $COUNTER = 0;
        {
            no warnings 'once';
            no warnings 'redefine';
            *Application::Model::Documents::get_raw_contracts = sub {
                my ($self, %opts) = @_;
                is_deeply(\%opts, {client_id => $fake_client_id,}, 'get_raw_contracts opts');
                return $fake_contracts->[$COUNTER];
            };
        }

        change_cur_user($app, 'mocked-yan-partner');
        foreach (1 .. @$fake_contracts) {
            $COUNTER = $_ - 1;
            eq_or_diff(
                $app->documents->get_active_contract({client_id => $fake_client_id, login => $fake_login}),
                $expected_active_for_partner->[$COUNTER],
                'get_active_contract return value'
            );
        }
    },
    init => [qw(documents)],
);
